/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xqdoc.ant;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.util.FileUtils;
import org.exist.xmldb.EXistXQueryService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XQDocTask
extends AbstractXMLDBTask {
    private static final String XQUERY = "import module namespace xqdm=\"http://exist-db.org/xquery/xqdoc\";\nimport module namespace xdb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace xqdoc=\"http://www.xqdoc.org/1.0\"\n;declare variable $uri external;\ndeclare variable $name external;\ndeclare variable $collection external;\ndeclare variable $data external;\nlet $xml :=\nif ($uri) then\n   xqdm:scan(xs:anyURI($uri))\nelse\n   xqdm:scan($data, $name)\nlet $moduleURI := $xml//xqdoc:module/xqdoc:uri\nlet $docName := concat(util:hash($moduleURI, 'MD5'), '.xml')\nreturn\n   xdb:store($collection, $docName, $xml, 'application/xml')";
    private String moduleURI = null;
    private boolean createCollection = false;
    private List<FileSet> fileSets = null;

    public void execute() throws BuildException {
        this.registerDatabase();
        try {
            int p = this.uri.indexOf("/db");
            if (p == -1) {
                throw new BuildException("invalid uri: '" + this.uri + "'");
            }
            String baseURI = this.uri.substring(0, p);
            String path = p == this.uri.length() - 3 ? "" : this.uri.substring(p + 3);
            Collection root = null;
            if (this.createCollection) {
                root = DatabaseManager.getCollection((String)(baseURI + "/db"), (String)this.user, (String)this.password);
                root = this.mkcol(root, baseURI, "/db", path);
            } else {
                root = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            }
            EXistXQueryService service = (EXistXQueryService)root.getService("XQueryService", "1.0");
            StringSource source = new StringSource(XQUERY);
            service.declareVariable("collection", (Object)root.getName());
            service.declareVariable("uri", (Object)"");
            if (this.moduleURI != null) {
                service.declareVariable("uri", (Object)this.moduleURI);
                service.declareVariable("data", (Object)"");
                service.execute((Source)source);
            } else {
                for (FileSet fileSet : this.fileSets) {
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    scanner.scan();
                    String[] files = scanner.getIncludedFiles();
                    this.log("Found " + files.length + " files to upload.\n");
                    Path baseDir = scanner.getBasedir().toPath();
                    for (int i = 0; i < files.length; ++i) {
                        Path file = baseDir.resolve(files[i]);
                        this.log("Storing " + files[i] + " ...\n");
                        byte[] data = this.read(file);
                        try {
                            service.declareVariable("name", (Object)FileUtils.fileName((Path)file));
                            service.declareVariable("data", (Object)data);
                            service.execute((Source)source);
                            continue;
                        }
                        catch (XMLDBException e) {
                            String msg = "XMLDB exception caught: " + e.getMessage();
                            if (this.failonerror) {
                                throw new BuildException(msg, (Throwable)e);
                            }
                            this.log(msg, e, 0);
                        }
                    }
                }
            }
        }
        catch (XMLDBException e) {
            String msg = "XMLDB exception caught: " + e.getMessage();
            if (this.failonerror) {
                throw new BuildException(msg, (Throwable)e);
            }
            this.log(msg, e, 0);
        }
    }

    public void setCreatecollection(boolean create) {
        this.createCollection = create;
    }

    public void setModuleuri(String uri) {
        this.moduleURI = uri;
    }

    public void addFileset(FileSet set) {
        if (this.fileSets == null) {
            this.fileSets = new ArrayList<FileSet>();
        }
        this.fileSets.add(set);
    }

    private byte[] read(Path file) throws BuildException {
        try {
            return Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new BuildException("IO error while reading XQuery source: " + file.toAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

