/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xqdoc.xquery;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.Database;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.BinarySource;
import org.exist.source.ClassLoaderSource;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xqdoc.XQDocHelper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xqdoc.conversion.XQDocException;

public class Scan
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("scan", "http://exist-db.org/xquery/xqdoc", "xqdm"), "Scan and extract function documentation from an external XQuery function module according to theXQDoc specification. The single argument URI may either point to an XQuery module stored in the db (URI starts with xmldb:exist:...) or a module in the file system. A file system module is searched in the same way as if it were loaded through an \"import module\" statement. Static mappings defined in conf.xml are searched first.", new SequenceType[]{new FunctionParameterSequenceType("uri", 25, 2, "The URI from which to load the function module")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "the function docs.")), new FunctionSignature(new QName("scan", "http://exist-db.org/xquery/xqdoc", "xqdm"), "Scan and extract function documentation from an external XQuery function module according to the XQDoc specification. The two parameter version of the function expects to get the source code of the module in the first argument and a name for the module in the second.", new SequenceType[]{new FunctionParameterSequenceType("data", 26, 2, "The base64 encoded source data of the module"), new FunctionParameterSequenceType("name", 22, 2, "The name of the module")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "the function docs."))};
    private static final Pattern NAME_PATTERN = Pattern.compile("([^/\\.]+)\\.?[^\\.]*$");
    private static final String NORMALIZE_XQUERY = "resource:org/exist/xqdoc/xquery/normalize.xql";
    private CompiledXQuery normalizeXQuery = null;

    public Scan(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    private byte[] binaryValueToByteArray(BinaryValue binaryValue) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        binaryValue.streamBinaryTo((OutputStream)baos);
        return baos.toByteArray();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String name;
        BinarySource source = null;
        if (this.getArgumentCount() == 2) {
            byte[] data;
            try {
                data = this.binaryValueToByteArray((BinaryValue)args[0].itemAt(0));
            }
            catch (IOException ioe) {
                throw new XPathException(ioe.getMessage(), (Throwable)ioe);
            }
            name = args[1].getStringValue();
            source = new BinarySource(data, true);
        } else {
            String uri = args[0].getStringValue();
            if (uri.startsWith("xmldb:")) {
                Collection collection = null;
                DocumentImpl doc = null;
                try {
                    XmldbURI resourceURI = XmldbURI.xmldbUriFor((String)uri);
                    collection = this.context.getBroker().openCollection(resourceURI.removeLastSegment(), Lock.LockMode.READ_LOCK);
                    if (collection == null) {
                        LOG.warn("collection not found: " + resourceURI.getCollectionPath());
                        Sequence sequence = Sequence.EMPTY_SEQUENCE;
                        return sequence;
                    }
                    doc = collection.getDocumentWithLock(this.context.getBroker(), resourceURI.lastSegment(), Lock.LockMode.READ_LOCK);
                    if (doc == null) {
                        Sequence sequence = Sequence.EMPTY_SEQUENCE;
                        return sequence;
                    }
                    if (doc.getResourceType() != 1 || !doc.getMetadata().getMimeType().equals("application/xquery")) {
                        throw new XPathException((Expression)this, "XQuery resource: " + uri + " is not an XQuery or declares a wrong mime-type");
                    }
                    source = new DBSource(this.context.getBroker(), (BinaryDocument)doc, false);
                    name = doc.getFileURI().toString();
                }
                catch (URISyntaxException e) {
                    throw new XPathException((Expression)this, "invalid module uri: " + uri + ": " + e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    throw new XPathException((Expression)this, "internal lock error: " + e.getMessage());
                }
                catch (PermissionDeniedException pde) {
                    throw new XPathException((Expression)this, pde.getMessage(), (Throwable)pde);
                }
                finally {
                    if (doc != null) {
                        doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    }
                    if (collection != null) {
                        collection.release(Lock.LockMode.READ_LOCK);
                    }
                }
            }
            String location = this.context.getModuleLocation(uri);
            if (location != null) {
                uri = location;
            }
            try {
                source = SourceFactory.getSource((DBBroker)this.context.getBroker(), (String)this.context.getModuleLoadPath(), (String)uri, (boolean)false);
                name = this.extractName(uri);
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, "failed to read module " + uri, (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XPathException((Expression)this, "permission denied to read module " + uri, (Throwable)e);
            }
        }
        try {
            XQDocHelper helper = new XQDocHelper();
            String xml = helper.scan((Source)source, name);
            NodeValue root = ModuleUtils.stringToXML((XQueryContext)this.context, (String)xml);
            if (root == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return this.normalize((NodeValue)((Document)root).getDocumentElement());
        }
        catch (XQDocException e) {
            throw new XPathException((Expression)this, "error while scanning module: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "IO error while scanning module: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, "error while scanning module: " + e.getMessage(), (Throwable)e);
        }
    }

    private String extractName(String uri) {
        Matcher matcher = NAME_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return uri;
    }

    private Sequence normalize(NodeValue input) throws IOException, XPathException {
        XQuery xquery = this.context.getBroker().getBrokerPool().getXQueryService();
        if (this.normalizeXQuery == null) {
            ClassLoaderSource source = new ClassLoaderSource(NORMALIZE_XQUERY);
            XQueryContext xc = new XQueryContext((Database)this.context.getBroker().getBrokerPool());
            try {
                this.normalizeXQuery = xquery.compile(this.context.getBroker(), xc, (Source)source);
            }
            catch (PermissionDeniedException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
        }
        try {
            this.normalizeXQuery.getContext().declareVariable("xqdoc:doc", (Object)input);
            return xquery.execute(this.context.getBroker(), this.normalizeXQuery, Sequence.EMPTY_SEQUENCE);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
    }
}

