/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.httpclient;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.ettrema.common.LogUtils;
import com.ettrema.httpclient.Folder;
import com.ettrema.httpclient.HttpException;
import com.ettrema.httpclient.ProgressListener;
import com.ettrema.httpclient.PropFindResponse;
import com.ettrema.httpclient.Resource;
import com.ettrema.httpclient.StreamReceiver;
import com.ettrema.httpclient.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(File.class);
    public final String contentType;
    public final Long contentLength;

    public File(Folder parent, PropFindResponse resp) {
        super(parent, resp);
        this.contentType = resp.getContentType();
        this.contentLength = resp.getContentLength();
    }

    public File(Folder parent, String name, String contentType, Long contentLength) {
        super(parent, name);
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    public void setContent(InputStream in, Long contentLength) throws IOException, HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        this.parent.upload(this.name, in, contentLength, null);
    }

    @Override
    public String toString() {
        return super.toString() + " (content type=" + this.contentType + ")";
    }

    @Override
    public java.io.File downloadTo(java.io.File destFolder, ProgressListener listener) throws FileNotFoundException, IOException, HttpException, Utils.CancelledException {
        if (!destFolder.exists()) {
            throw new FileNotFoundException(destFolder.getAbsolutePath());
        }
        java.io.File dest = destFolder.isFile() ? destFolder : new java.io.File(destFolder, this.name);
        this.downloadToFile(dest, listener);
        return dest;
    }

    public void downloadToFile(java.io.File dest, ProgressListener listener) throws FileNotFoundException, HttpException, Utils.CancelledException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"downloadToFile", this.name});
        if (listener != null) {
            listener.onProgress(0L, dest.length(), this.name);
        }
        try {
            Path path = this.path();
            this.host().doGet(path, dest, listener);
        }
        catch (Utils.CancelledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (listener != null) {
            long length = dest.length();
            listener.onProgress(length, length, this.name);
            listener.onComplete(this.name);
        }
    }

    public void download(OutputStream out, ProgressListener listener) throws HttpException, Utils.CancelledException {
        this.download(out, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(final OutputStream out, final ProgressListener listener, List<Range> rangeList) throws HttpException, Utils.CancelledException {
        if (listener != null) {
            listener.onProgress(0L, null, this.name);
        }
        final long[] bytesArr = new long[1];
        try {
            this.host().doGet(this.encodedUrl(), new StreamReceiver(){

                @Override
                public void receive(InputStream in) throws IOException {
                    if (listener != null && listener.isCancelled()) {
                        throw new RuntimeException("Download cancelled");
                    }
                    try {
                        long bytes;
                        bytesArr[0] = bytes = Utils.write(in, out, listener);
                    }
                    catch (Utils.CancelledException cancelled) {
                        throw cancelled;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                }
            }, rangeList, listener);
        }
        catch (Utils.CancelledException e) {
            throw e;
        }
        catch (Throwable e) {
        }
        finally {
            Utils.close(out);
        }
        if (listener != null) {
            long l = bytesArr[0];
            listener.onProgress(l, l, this.name);
            listener.onComplete(this.name);
        }
    }

    @Override
    public String encodedUrl() {
        return this.parent.encodedUrl() + this.encodedName();
    }
}

