/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceCompilationException;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceRegistryManager;
import org.exist.extensions.exquery.restxq.impl.XQueryCompiler;
import org.exist.extensions.exquery.restxq.impl.XQueryInspector;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exquery.ExQueryException;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistry;

public class ExistXqueryRegistry {
    private static final ExistXqueryRegistry instance = new ExistXqueryRegistry();
    private static final Logger LOG = LogManager.getLogger(ExistXqueryRegistry.class);
    private static final Map<String, Set<String>> dependenciesTree = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> missingDependencies = new HashMap<String, Set<String>>();
    private static final Set<String> invalidQueries = new HashSet<String>();

    private ExistXqueryRegistry() {
    }

    public static ExistXqueryRegistry getInstance() {
        return instance;
    }

    public Map<String, Set<String>> getDependenciesTree() {
        HashMap<String, Set<String>> copy = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> dependencyTree : dependenciesTree.entrySet()) {
            copy.put(dependencyTree.getKey(), new HashSet(dependencyTree.getValue()));
        }
        return copy;
    }

    public Map<String, Set<String>> getMissingDependencies() {
        HashMap<String, Set<String>> copy = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> missingDependency : missingDependencies.entrySet()) {
            copy.put(missingDependency.getKey(), new HashSet(missingDependency.getValue()));
        }
        return copy;
    }

    public Set<String> getInvalidQueries() {
        return new HashSet<String>(invalidQueries);
    }

    public boolean isXquery(DocumentImpl document) {
        return document instanceof BinaryDocument && document.getMetadata().getMimeType().equals("application/xquery");
    }

    public void registerServices(DBBroker broker, List<RestXqService> services) {
        this.getRegistry(broker).register(services);
    }

    public void deregisterServices(DBBroker broker, XmldbURI xqueryLocation) {
        this.getRegistry(broker).deregister(xqueryLocation.getURI());
        for (String dependant : this.getDependants(xqueryLocation)) {
            try {
                if (dependant == null) continue;
                this.getRegistry(broker).deregister(new URI(dependant));
                this.recordMissingDependency(xqueryLocation.toString(), XmldbURI.create((String)dependant));
            }
            catch (URISyntaxException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deregisterService(DBBroker broker, RestXqService service) {
        this.getRegistry(broker).deregister(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDependants(XmldbURI xqueryLocation) {
        HashMap<String, Set<String>> depTree;
        HashSet<String> dependants = new HashSet<String>();
        Map<String, Set<String>> map = dependenciesTree;
        synchronized (map) {
            depTree = new HashMap<String, Set<String>>(dependenciesTree);
        }
        for (Map.Entry entry : depTree.entrySet()) {
            for (String dependency : (Set)entry.getValue()) {
                if (!dependency.equals(xqueryLocation.toString())) continue;
                dependants.add((String)entry.getKey());
            }
        }
        return dependants;
    }

    public Iterator<RestXqService> registered(DBBroker broker) {
        return this.getRegistry(broker).iterator();
    }

    public List<RestXqService> findServices(DBBroker broker, DocumentImpl document) throws ExQueryException {
        try {
            CompiledXQuery compiled = XQueryCompiler.compile(broker, document);
            Map<String, Set<String>> queryDependenciesTree = XQueryInspector.getDependencies(compiled);
            this.recordQueryDependenciesTree(queryDependenciesTree);
            this.reexamineModulesWithResolvedDependencies(broker, document.getURI().toString());
            this.removeInvalidQuery(document.getURI());
            return XQueryInspector.findServices(compiled);
        }
        catch (RestXqServiceCompilationException e) {
            MissingModuleHint missingModuleHint = this.extractMissingModuleHint(e);
            if (missingModuleHint != null) {
                if (missingModuleHint.dependantModule == null) {
                    this.recordMissingDependency(missingModuleHint.moduleHint, document.getURI());
                } else {
                    try {
                        this.recordMissingDependency(missingModuleHint.dependantModule, document.getURI());
                        this.recordMissingDependency(missingModuleHint.moduleHint, XmldbURI.xmldbUriFor((String)missingModuleHint.dependantModule));
                    }
                    catch (URISyntaxException use) {
                        this.recordInvalidQuery(document.getURI());
                        LOG.error("XQuery '" + document.getURI() + "' could not be compiled! " + e.getMessage());
                    }
                }
            } else {
                this.recordInvalidQuery(document.getURI());
                LOG.error("XQuery '" + document.getURI() + "' could not be compiled! " + e.getMessage());
            }
            return new ArrayList<RestXqService>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reexamineModulesWithResolvedDependencies(DBBroker broker, String compiledModuleUri) {
        HashSet<Object> dependants;
        Map<String, Set<String>> map = missingDependencies;
        synchronized (map) {
            Set<String> set = missingDependencies.get(compiledModuleUri);
            dependants = set != null ? new HashSet<String>(set) : new HashSet();
        }
        for (String string : dependants) {
            try {
                DocumentImpl dependantModule = broker.getResource(XmldbURI.create((String)string), 4);
                if (dependantModule != null) {
                    LOG.info("Missing dependency '" + compiledModuleUri + "' has been added to the database, re-examining '" + string + "'...");
                    List<RestXqService> services = this.findServices(broker, dependantModule);
                    LOG.info("Discovered " + services.size() + " resource functions for " + string);
                    this.registerServices(broker, services);
                } else {
                    LOG.info("Dependant '" + compiledModuleUri + "' has been resolved. Dependency on: " + string + " was removed");
                    this.removeDependency(string, compiledModuleUri);
                }
            }
            catch (PermissionDeniedException | ExQueryException pde) {
                LOG.error(pde.getMessage(), pde);
            }
            this.removeMissingDependency(compiledModuleUri, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMissingDependency(String dependency, String dependant) {
        Map<String, Set<String>> map = missingDependencies;
        synchronized (map) {
            Set<String> missingDependants = missingDependencies.get(dependency);
            missingDependants.remove(dependant);
            if (missingDependants.isEmpty()) {
                missingDependencies.remove(dependency);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordQueryDependenciesTree(Map<String, Set<String>> queryDependenciesTree) {
        Map<String, Set<String>> map = dependenciesTree;
        synchronized (map) {
            dependenciesTree.putAll(queryDependenciesTree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidQuery(XmldbURI xqueryUri) {
        Set<String> set = invalidQueries;
        synchronized (set) {
            invalidQueries.remove(xqueryUri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordInvalidQuery(XmldbURI xqueryUri) {
        Set<String> set = invalidQueries;
        synchronized (set) {
            invalidQueries.add(xqueryUri.toString());
        }
    }

    private MissingModuleHint extractMissingModuleHint(RestXqServiceCompilationException e) {
        Sequence errorVals;
        XPathException xpe;
        MissingModuleHint missingModuleHint = null;
        if (e.getCause() instanceof XPathException && (xpe = (XPathException)e.getCause()).getErrorCode() == ErrorCodes.XQST0059 && (errorVals = xpe.getErrorVal()) != null && errorVals.getItemCount() > 0) {
            Item errorVal2;
            Item errorVal1 = errorVals.itemAt(0);
            if (errorVal1 instanceof StringValue) {
                missingModuleHint = new MissingModuleHint();
                missingModuleHint.moduleHint = ((StringValue)errorVal1).getStringValue();
            }
            if (errorVals.getItemCount() == 2 && (errorVal2 = errorVals.itemAt(1)) instanceof StringValue) {
                if (missingModuleHint == null) {
                    missingModuleHint = new MissingModuleHint();
                }
                String dependantModuleUri = ((StringValue)errorVal2).getStringValue();
                missingModuleHint.dependantModule = this.makeDbAbsolutePath(dependantModuleUri);
            }
        }
        return missingModuleHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordMissingDependency(String moduleHint, XmldbURI xqueryUri) {
        String moduleUri = this.getAbsoluteModuleHint(moduleHint, xqueryUri);
        Map<String, Set<String>> map = missingDependencies;
        synchronized (map) {
            Set<Object> dependants = missingDependencies.containsKey(moduleUri) ? missingDependencies.get(moduleUri) : new HashSet();
            dependants.add(xqueryUri.toString());
            missingDependencies.put(moduleUri, dependants);
        }
        LOG.warn("Module '" + xqueryUri + "' has a missing dependency on '" + moduleUri + "'. Will re-examine if the missing module is added.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDependency(String dependant, String dependency) {
        Map<String, Set<String>> map = dependenciesTree;
        synchronized (map) {
            Set<String> dependencies = dependenciesTree.get(dependant);
            if (dependencies != null) {
                dependencies.remove(dependency);
                if (dependencies.isEmpty()) {
                    dependenciesTree.remove(dependant);
                }
            }
        }
    }

    protected String getAbsoluteModuleHint(String moduleHint, XmldbURI xqueryUri) {
        if (moduleHint.startsWith("/db")) {
            return moduleHint;
        }
        if (moduleHint.startsWith(XmldbURI.EMBEDDED_SERVER_URI.toString())) {
            return moduleHint.replace(XmldbURI.EMBEDDED_SERVER_URI.toString(), "");
        }
        if (moduleHint.startsWith("xmldb:exist://")) {
            return moduleHint.replace("xmldb:exist://", "");
        }
        XmldbURI xqueryPath = xqueryUri.removeLastSegment();
        return xqueryPath.append(moduleHint).toString();
    }

    private String makeDbAbsolutePath(String dependantModuleUri) {
        dependantModuleUri = dependantModuleUri.replace(XmldbURI.EMBEDDED_SERVER_URI.toString(), "");
        if (!(dependantModuleUri = dependantModuleUri.replace("xmldb:exist://", "")).isEmpty() && !dependantModuleUri.startsWith("/")) {
            dependantModuleUri = dependantModuleUri.substring(dependantModuleUri.indexOf("/"));
        }
        return dependantModuleUri;
    }

    private RestXqServiceRegistry getRegistry(DBBroker broker) {
        return RestXqServiceRegistryManager.getRegistry(broker.getBrokerPool());
    }

    private static class MissingModuleHint {
        public String moduleHint = null;
        public String dependantModule = null;

        private MissingModuleHint() {
        }
    }
}

