/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Function;
import org.exist.extensions.exquery.restxq.RestXqServiceCompiledXQueryCache;
import org.exist.extensions.exquery.restxq.impl.XQueryCompiler;
import org.exist.storage.DBBroker;
import org.exist.xquery.CompiledXQuery;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceException;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;

public class RestXqServiceCompiledXQueryCacheImpl
implements RestXqServiceCompiledXQueryCache {
    private static final RestXqServiceCompiledXQueryCacheImpl INSTANCE = new RestXqServiceCompiledXQueryCacheImpl();
    private static final int DEFAULT_MAX_POOL_SIZE = 256;
    private static final int DEFAULT_MAX_QUERY_STACK_SIZE = 64;
    private final Cache<URI, Queue<CompiledXQuery>> cache = Caffeine.newBuilder().maximumSize(256L).build();

    private RestXqServiceCompiledXQueryCacheImpl() {
    }

    public static RestXqServiceCompiledXQueryCacheImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public CompiledXQuery getCompiledQuery(DBBroker broker, URI xqueryLocation) throws RestXqServiceException {
        Queue queue = (Queue)this.cache.get((Object)xqueryLocation, key -> new MpmcAtomicArrayQueue(64));
        CompiledXQuery xquery = (CompiledXQuery)queue.poll();
        if (xquery == null) {
            xquery = XQueryCompiler.compile(broker, xqueryLocation);
        }
        xquery.reset();
        xquery.getContext().getWatchDog().reset();
        xquery.getContext().prepareForExecution();
        return xquery;
    }

    @Override
    public void returnCompiledQuery(URI xqueryLocation, CompiledXQuery xquery) {
        xquery.reset();
        xquery.getContext().reset();
        Queue queue = (Queue)this.cache.get((Object)xqueryLocation, key -> new MpmcAtomicArrayQueue(64));
        queue.offer(xquery);
    }

    @Override
    public void removeService(RestXqService service) {
        URI xqueryLocation = service.getResourceFunction().getXQueryLocation();
        this.cache.invalidate((Object)xqueryLocation);
    }

    @Override
    public void removeServices(Iterable<RestXqService> services) {
        this.cache.invalidateAll(RestXqServiceCompiledXQueryCacheImpl.mapIterable(services, restXqService -> restXqService.getResourceFunction().getXQueryLocation()));
    }

    private static <T, U> Iterable<U> mapIterable(final Iterable<T> input, final Function<T, U> mapper) {
        return new Iterable<U>(){

            @Override
            public Iterator<U> iterator() {
                final Iterator it = input.iterator();
                return new Iterator<U>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public U next() {
                        return mapper.apply(it.next());
                    }
                };
            }
        };
    }
}

