/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.extensions.exquery.xdm.type.impl.BinaryTypedValue;
import org.exist.extensions.exquery.xdm.type.impl.DocumentTypedValue;
import org.exist.extensions.exquery.xdm.type.impl.StringTypedValue;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.io.CachingFilterInputStream;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheFactory;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.StringValue;
import org.exquery.http.HttpRequest;
import org.exquery.http.HttpResponse;
import org.exquery.restxq.ResourceFunction;
import org.exquery.restxq.ResourceFunctionExecuter;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.RestXqServiceException;
import org.exquery.restxq.RestXqServiceSerializer;
import org.exquery.restxq.impl.AbstractRestXqService;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.Type;
import org.exquery.xquery.TypedValue;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class RestXqServiceImpl
extends AbstractRestXqService {
    private static final Logger LOG = LogManager.getLogger(RestXqServiceImpl.class);
    private final BrokerPool brokerPool;
    private final BinaryValueManager binaryValueManager;

    public RestXqServiceImpl(ResourceFunction resourceFunction, BrokerPool brokerPool) {
        super(resourceFunction);
        this.brokerPool = brokerPool;
        this.binaryValueManager = new BinaryValueManager(){
            final Deque<BinaryValue> binaryValues = new ArrayDeque<BinaryValue>();

            public void registerBinaryValueInstance(BinaryValue binaryValue) {
                this.binaryValues.push(binaryValue);
            }

            public void runCleanupTasks(Predicate<Object> predicate) {
                while (!this.binaryValues.isEmpty()) {
                    try {
                        if (!predicate.test(this.binaryValues.peek())) continue;
                        BinaryValue binaryValue = this.binaryValues.pop();
                        binaryValue.close();
                    }
                    catch (IOException ioe) {
                        LOG.error("Unable to close binary value: " + ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }

            public String getCacheClass() {
                return (String)RestXqServiceImpl.this.getBrokerPool().getConfiguration().getProperty("binary.cache.class");
            }
        };
    }

    private BrokerPool getBrokerPool() {
        return this.brokerPool;
    }

    public void service(HttpRequest request, HttpResponse response, ResourceFunctionExecuter resourceFunctionExecuter, RestXqServiceSerializer restXqServiceSerializer) throws RestXqServiceException {
        super.service(request, response, resourceFunctionExecuter, restXqServiceSerializer);
        this.binaryValueManager.runCleanupTasks();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Sequence extractRequestBody(HttpRequest request) throws RestXqServiceException {
        SequenceImpl result;
        CloseShieldInputStream is;
        block38: {
            FilterInputStreamCache cache = null;
            try {
                is = new CloseShieldInputStream(request.getInputStream());
                if (is.available() <= 0) {
                    return null;
                }
                if (!is.markSupported()) {
                    cache = FilterInputStreamCacheFactory.getCacheInstance(() -> {
                        Configuration configuration = this.getBrokerPool().getConfiguration();
                        return (String)configuration.getProperty("binary.cache.class");
                    }, (InputStream)is);
                    is = new CachingFilterInputStream(cache);
                }
                is.mark(Integer.MAX_VALUE);
            }
            catch (IOException ioe) {
                throw new RestXqServiceException(RestXqErrorCodes.RQDY0014, (Throwable)ioe);
            }
            result = null;
            try {
                if (is != null && is.available() > 0) {
                    DocumentImpl doc;
                    String contentType = request.getContentType();
                    if (contentType != null) {
                        MimeType mimeType;
                        if (contentType.contains(";")) {
                            contentType = contentType.substring(0, contentType.indexOf(";"));
                        }
                        if ((mimeType = MimeTable.getInstance().getContentType(contentType)) != null && !mimeType.isXMLType()) {
                            try {
                                BinaryValueFromInputStream binaryValue = BinaryValueFromInputStream.getInstance((BinaryValueManager)this.binaryValueManager, (BinaryValueType)new Base64BinaryValueType(), (InputStream)is);
                                if (binaryValue != null) {
                                    result = new SequenceImpl((TypedValue)new BinaryTypedValue((BinaryValue)binaryValue));
                                }
                            }
                            catch (XPathException xpe) {
                                throw new RestXqServiceException(RestXqErrorCodes.RQDY0014, (Throwable)xpe);
                            }
                        }
                    }
                    if (result == null && (doc = this.parseAsXml((InputStream)is)) != null) {
                        result = new SequenceImpl((TypedValue)new DocumentTypedValue(doc));
                    }
                    if (result == null) {
                        String encoding = request.getCharacterEncoding();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        try {
                            is.reset();
                            StringValue str = RestXqServiceImpl.parseAsString((InputStream)is, encoding);
                            if (str != null) {
                                result = new SequenceImpl((TypedValue)new StringTypedValue(str));
                            }
                        }
                        catch (IOException ioe) {
                            throw new RestXqServiceException(RestXqErrorCodes.RQDY0014, (Throwable)ioe);
                        }
                    }
                }
                if (cache == null) break block38;
            }
            catch (IOException e) {
                try {
                    throw new RestXqServiceException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (cache != null) {
                        try {
                            cache.invalidate();
                        }
                        catch (IOException ioe) {
                            LOG.error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                    if (is == null) throw throwable;
                    boolean isBinaryType = false;
                    if (result != null) {
                        try {
                            Type type = result.head().getType();
                            isBinaryType = type == Type.BASE64_BINARY || type == Type.HEX_BINARY;
                        }
                        catch (IndexOutOfBoundsException ioe) {
                            LOG.warn("Called head on an empty HTTP Request body sequence", (Throwable)ioe);
                        }
                    }
                    if (isBinaryType) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        LOG.error(ioe.getMessage(), (Throwable)ioe);
                    }
                    throw throwable;
                }
            }
            try {
                cache.invalidate();
            }
            catch (IOException ioe) {
                LOG.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        if (is != null) {
            boolean isBinaryType = false;
            if (result != null) {
                try {
                    Type type = result.head().getType();
                    isBinaryType = type == Type.BASE64_BINARY || type == Type.HEX_BINARY;
                }
                catch (IndexOutOfBoundsException ioe) {
                    LOG.warn("Called head on an empty HTTP Request body sequence", (Throwable)ioe);
                }
            }
            if (!isBinaryType) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
        if (result == null) return Sequence.EMPTY_SEQUENCE;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DocumentImpl parseAsXml(InputStream is) {
        DocumentImpl result = null;
        XMLReader reader = null;
        try {
            InputSource src = new InputSource((InputStream)new CloseShieldInputStream(is));
            reader = this.getBrokerPool().getParserPool().borrowXMLReader();
            MemTreeBuilder builder = new MemTreeBuilder();
            builder.startDocument();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder, true);
            reader.setContentHandler((ContentHandler)receiver);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", receiver);
            reader.parse(src);
            builder.endDocument();
            Document doc = receiver.getDocument();
            result = (DocumentImpl)doc;
            if (reader == null) return result;
        }
        catch (IOException | SAXException exception) {
            if (reader == null) return result;
            this.getBrokerPool().getParserPool().returnXMLReader(reader);
            return result;
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                this.getBrokerPool().getParserPool().returnXMLReader(reader);
                throw throwable;
            }
        }
        this.getBrokerPool().getParserPool().returnXMLReader(reader);
        return result;
    }

    private static StringValue parseAsString(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int read = -1;
        while ((read = is.read(buf)) > -1) {
            bos.write(buf, 0, read);
        }
        String s = new String(bos.toByteArray(), encoding);
        return new StringValue(s);
    }
}

