/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceRegistryPersistence;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistryListener;

class RestXqServiceRegistryLogger
implements RestXqServiceRegistryListener {
    private final Logger log = LogManager.getLogger(this.getClass());

    RestXqServiceRegistryLogger() {
    }

    public void registered(RestXqService service) {
        this.log.info("Registered RESTXQ Resource Function: " + this.getIdentifier(service));
    }

    public void deregistered(RestXqService service) {
        this.log.info("De-registered RESTXQ Resource Function: " + this.getIdentifier(service));
    }

    private String getIdentifier(RestXqService service) {
        StringBuilder builder = new StringBuilder();
        builder.append(service.getResourceFunction().getXQueryLocation());
        builder.append(",");
        builder.append(RestXqServiceRegistryPersistence.qnameToClarkNotation(service.getResourceFunction().getFunctionSignature().getName()));
        builder.append("#");
        builder.append(service.getResourceFunction().getFunctionSignature().getArgumentCount());
        return builder.toString();
    }
}

