/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.extensions.exquery.restxq.impl.XQueryCompiler;
import org.exist.extensions.exquery.restxq.impl.XQueryInspector;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;
import org.exist.xquery.CompiledXQuery;
import org.exquery.ExQueryException;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistry;
import org.exquery.restxq.RestXqServiceRegistryListener;
import org.exquery.xquery3.FunctionSignature;

public class RestXqServiceRegistryPersistence
implements RestXqServiceRegistryListener {
    public static final int REGISTRY_FILE_VERSION = 1;
    private static final String VERSION_LABEL = "version";
    private static final String LABEL_SEP = ": ";
    public static final String FIELD_SEP = ",";
    public static final String ARITY_SEP = "#";
    public static final String REGISTRY_FILENAME = "restxq.registry";
    private final Logger log = LogManager.getLogger(this.getClass());
    private final BrokerPool pool;
    private final RestXqServiceRegistry registry;

    public RestXqServiceRegistryPersistence(BrokerPool pool, RestXqServiceRegistry registry) {
        this.pool = pool;
        this.registry = registry;
    }

    private BrokerPool getBrokerPool() {
        return this.pool;
    }

    private RestXqServiceRegistry getRegistry() {
        return this.registry;
    }

    public void loadRegistry() {
        this.getRegistryFile(false).filter(r -> Files.exists(r, new LinkOption[0])).filter(r -> Files.isRegularFile(r, new LinkOption[0])).ifPresent(this::loadRegistry);
    }

    private void loadRegistry(Path fRegistry) {
        this.log.info("Loading RESTXQ registry from: " + fRegistry.toAbsolutePath().toString());
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(fRegistry));
             DBBroker broker = this.getBrokerPool().getBroker();){
            String line = reader.readLine();
            String versionStr = line.substring(line.indexOf(VERSION_LABEL) + VERSION_LABEL.length() + LABEL_SEP.length());
            if (1 != Integer.parseInt(versionStr)) {
                this.log.error("Unable to load RESTXQ registry file: " + fRegistry.toAbsolutePath().toString() + ". Expected version: " + 1 + " but saw version: " + versionStr);
            } else {
                while ((line = reader.readLine()) != null) {
                    String xqueryLocation = line.substring(0, line.indexOf(FIELD_SEP));
                    CompiledXQuery xquery = XQueryCompiler.compile(broker, new URI(xqueryLocation));
                    List<RestXqService> services = XQueryInspector.findServices(xquery);
                    this.getRegistry().register(services);
                }
            }
        }
        catch (IOException | URISyntaxException | EXistException | ExQueryException eqe) {
            this.log.error(eqe.getMessage(), eqe);
        }
        this.log.info("RESTXQ registry loaded.");
    }

    public void registered(RestXqService service) {
        this.updateRegistryOnDisk(service, UpdateAction.ADD);
    }

    public void deregistered(RestXqService service) {
        this.updateRegistryOnDisk(service, UpdateAction.REMOVE);
    }

    private synchronized void updateRegistryOnDisk(RestXqService restXqService, UpdateAction updateAction) {
        Optional<Path> optNewRegistry = this.getRegistryFile(true);
        if (!optNewRegistry.isPresent()) {
            this.log.error("Could not save RESTXQ Registry to disk!");
        } else {
            Path newRegistry = optNewRegistry.get();
            this.log.info("Preparing new RESTXQ registry on disk: " + newRegistry.toAbsolutePath().toString());
            try {
                try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(newRegistry, StandardOpenOption.TRUNCATE_EXISTING));){
                    writer.println("version: 1");
                    HashMap<URI, ArrayList<FunctionSignature>> xqueryServices = new HashMap<URI, ArrayList<FunctionSignature>>();
                    for (RestXqService service : this.getRegistry()) {
                        ArrayList<FunctionSignature> fnNames = (ArrayList<FunctionSignature>)xqueryServices.get(service.getResourceFunction().getXQueryLocation());
                        if (fnNames == null) {
                            fnNames = new ArrayList<FunctionSignature>();
                        }
                        fnNames.add(service.getResourceFunction().getFunctionSignature());
                        xqueryServices.put(service.getResourceFunction().getXQueryLocation(), fnNames);
                    }
                    for (Map.Entry xqueryServiceFunctions : xqueryServices.entrySet()) {
                        writer.print(xqueryServiceFunctions.getKey() + FIELD_SEP);
                        List fnSigs = (List)xqueryServiceFunctions.getValue();
                        for (FunctionSignature fnSig : fnSigs) {
                            writer.print(RestXqServiceRegistryPersistence.qnameToClarkNotation(fnSig.getName()) + ARITY_SEP + fnSig.getArgumentCount());
                        }
                        writer.println();
                    }
                }
                Optional<Path> optRegistry = this.getRegistryFile(false);
                if (!optRegistry.isPresent()) {
                    throw new IOException("Unable to retrieve existing RESTXQ registry");
                }
                Path registry = optRegistry.get();
                Files.move(newRegistry, registry, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                this.log.info("Replaced RESTXQ registry: " + FileUtils.fileName((Path)newRegistry) + " -> " + FileUtils.fileName((Path)registry));
            }
            catch (IOException ioe) {
                this.log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    public static String qnameToClarkNotation(QName qname) {
        if (qname.getNamespaceURI() == null) {
            return qname.getLocalPart();
        }
        return "{" + qname.getNamespaceURI() + "}" + qname.getLocalPart();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Path> getRegistryFile(boolean temp) {
        try (DBBroker broker = this.getBrokerPool().getBroker();){
            Configuration configuration = broker.getConfiguration();
            Path dataDir = (Path)configuration.getProperty("db-connection.data-dir");
            Path registryFile = temp ? Files.createTempFile(dataDir, REGISTRY_FILENAME, ".tmp", new FileAttribute[0]) : dataDir.resolve(REGISTRY_FILENAME);
            Optional<Path> optional = Optional.of(registryFile);
            return optional;
        }
        catch (IOException | EXistException e) {
            this.log.error(e.getMessage(), e);
            return Optional.empty();
        }
    }

    private static enum UpdateAction {
        ADD,
        REMOVE;

    }
}

