/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.extensions.exquery.restxq.impl.ResourceFunctionExecutorImpl;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceRegistryManager;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceSerializerImpl;
import org.exist.extensions.exquery.restxq.impl.adapters.HttpServletRequestAdapter;
import org.exist.extensions.exquery.restxq.impl.adapters.HttpServletResponseAdapter;
import org.exist.http.servlets.AbstractExistHttpServlet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exquery.http.HttpRequest;
import org.exquery.http.HttpResponse;
import org.exquery.restxq.ResourceFunctionExecuter;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceException;
import org.exquery.restxq.RestXqServiceRegistry;
import org.exquery.restxq.RestXqServiceSerializer;

public class RestXqServlet
extends AbstractExistHttpServlet {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    private RestXqServiceRegistry getRegistry() {
        return RestXqServiceRegistryManager.getRegistry(this.getPool());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Subject user = this.authenticate(request, response);
        if (user == null) {
            return;
        }
        try (DBBroker broker = this.getPool().get(Optional.of(user));){
            Configuration configuration = broker.getConfiguration();
            HttpServletRequestAdapter requestAdapter = new HttpServletRequestAdapter(request, () -> (String)configuration.getProperty("binary.cache.class"));
            RestXqService service = this.getRegistry().findService((HttpRequest)requestAdapter);
            if (service != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Received " + requestAdapter.getMethod().name() + " request for \"" + requestAdapter.getPath() + "\" and found Resource Function \"" + service.getResourceFunction().getFunctionSignature() + "\" in  module \"" + service.getResourceFunction().getXQueryLocation() + "\"");
                }
                service.service((HttpRequest)requestAdapter, (HttpResponse)new HttpServletResponseAdapter(response), (ResourceFunctionExecuter)new ResourceFunctionExecutorImpl(this.getPool(), request.getContextPath() + request.getServletPath(), request.getRequestURI()), (RestXqServiceSerializer)new RestXqServiceSerializerImpl(this.getPool()));
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Received " + requestAdapter.getMethod().name() + " request for \"" + requestAdapter.getPath() + "\" but no suitable Resource Function found!");
                }
                super.service(request, response);
            }
        }
        catch (EXistException e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (RestXqServiceException e) {
            if (e.getCause() instanceof PermissionDeniedException) {
                this.getAuthenticator().sendChallenge(request, response);
            }
            this.getLog().error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public Logger getLog() {
        return this.log;
    }
}

