/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.io.IOException;
import java.net.URI;
import org.exist.Database;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceCompilationException;
import org.exist.security.PermissionDeniedException;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;

class XQueryCompiler {
    public static final String XQUERY_MIME_TYPE = "application/xquery";

    XQueryCompiler() {
    }

    public static CompiledXQuery compile(DBBroker broker, URI xqueryLocation) throws RestXqServiceCompilationException {
        try {
            DocumentImpl document = broker.getResource(XmldbURI.create((URI)xqueryLocation), 4);
            if (document != null) {
                return XQueryCompiler.compile(broker, document);
            }
            throw new RestXqServiceCompilationException("Invalid document location for XQuery: " + xqueryLocation.toString());
        }
        catch (PermissionDeniedException pde) {
            throw new RestXqServiceCompilationException("Permission to access XQuery denied: " + xqueryLocation.toString() + ": " + pde.getMessage(), pde);
        }
    }

    public static CompiledXQuery compile(DBBroker broker, DocumentImpl document) throws RestXqServiceCompilationException {
        try {
            if (document instanceof BinaryDocument) {
                DocumentMetadata metadata = document.getMetadata();
                if (metadata.getMimeType().equals(XQUERY_MIME_TYPE)) {
                    XQueryContext context = new XQueryContext((Database)broker.getBrokerPool());
                    DBSource source = new DBSource(broker, (BinaryDocument)document, true);
                    context.setModuleLoadPath("xmldb:exist://" + ((XmldbURI)source.getKey()).removeLastSegment());
                    return broker.getBrokerPool().getXQueryService().compile(broker, context, (Source)source);
                }
                throw new RestXqServiceCompilationException("Invalid mimetype '" + metadata.getMimeType() + "' for XQuery: " + document.getURI().toString());
            }
            throw new RestXqServiceCompilationException("Invalid document location for XQuery: " + document.getURI().toString());
        }
        catch (XPathException xpe) {
            throw new RestXqServiceCompilationException("Unable to compile XQuery: " + document.getURI().toString() + ": " + xpe.getMessage(), xpe);
        }
        catch (IOException ioe) {
            throw new RestXqServiceCompilationException("Unable to access XQuery: " + document.getURI().toString() + ": " + ioe.getMessage(), ioe);
        }
        catch (PermissionDeniedException pde) {
            throw new RestXqServiceCompilationException("Permission to access XQuery denied: " + document.getURI().toString() + ": " + pde.getMessage(), pde);
        }
    }
}

