/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl.adapters;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class DomEnhancingNodeProxyAdapter {
    DomEnhancingNodeProxyAdapter() {
    }

    public static NodeProxy create(NodeProxy nodeProxy) {
        Class[] clazzes = DomEnhancingNodeProxyAdapter.getNodeClasses(nodeProxy);
        Callback[] callbacks = new Callback[]{NoOp.INSTANCE, new NodeDispatcher(nodeProxy)};
        CallbackFilter callbackFilter = method -> {
            Class<?> declaringClass = method.getDeclaringClass();
            boolean isMethodOnNode = false;
            if (declaringClass.equals(Node.class)) {
                isMethodOnNode = true;
            } else {
                for (Class<?> iface : declaringClass.getInterfaces()) {
                    if (!iface.equals(Node.class)) continue;
                    isMethodOnNode = true;
                    break;
                }
            }
            if (isMethodOnNode) {
                return 1;
            }
            return 0;
        };
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(NodeProxy.class);
        enhancer.setInterfaces(clazzes);
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(callbacks);
        return (NodeProxy)enhancer.create(new Class[]{NodeHandle.class}, new Object[]{nodeProxy});
    }

    private static Class<? extends Node>[] getNodeClasses(NodeProxy nodeProxy) {
        switch (nodeProxy.getType()) {
            case 6: {
                return new Class[]{Document.class, Node.class};
            }
            case 1: {
                return new Class[]{Element.class, Node.class};
            }
            case 2: {
                return new Class[]{Attr.class, Node.class};
            }
            case 3: {
                return new Class[]{Text.class, Node.class};
            }
        }
        return new Class[]{Node.class};
    }

    public static class NodeDispatcher
    implements Dispatcher {
        private final NodeProxy nodeProxy;

        public NodeDispatcher(NodeProxy nodeProxy) {
            this.nodeProxy = nodeProxy;
        }

        public Object loadObject() throws Exception {
            return this.nodeProxy.getNode();
        }
    }
}

