/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl.adapters;

import javax.xml.namespace.QName;
import org.exist.extensions.exquery.restxq.impl.adapters.AnnotationAdapter;
import org.exist.extensions.exquery.restxq.impl.adapters.FunctionParameterSequenceTypeAdapter;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.SequenceType;
import org.exquery.xquery.FunctionArgument;
import org.exquery.xquery3.Annotation;

class FunctionSignatureAdapter
implements org.exquery.xquery3.FunctionSignature {
    private QName name;
    private int argumentCount;
    private FunctionParameterSequenceTypeAdapter[] arguments;
    private AnnotationAdapter[] annotations;

    protected FunctionSignatureAdapter() {
    }

    public FunctionSignatureAdapter(FunctionSignature functionSignature) {
        org.exist.xquery.Annotation[] fnAnnotations;
        this.name = functionSignature.getName().toJavaQName();
        this.argumentCount = functionSignature.getArgumentCount();
        SequenceType[] fnArgumentTypes = functionSignature.getArgumentTypes();
        if (fnArgumentTypes != null) {
            this.arguments = new FunctionParameterSequenceTypeAdapter[fnArgumentTypes.length];
            for (int i = 0; i < fnArgumentTypes.length; ++i) {
                this.arguments[i] = new FunctionParameterSequenceTypeAdapter((FunctionParameterSequenceType)fnArgumentTypes[i]);
            }
        } else {
            this.arguments = null;
        }
        if ((fnAnnotations = functionSignature.getAnnotations()) != null) {
            this.annotations = new AnnotationAdapter[fnAnnotations.length];
            for (int i = 0; i < fnAnnotations.length; ++i) {
                this.annotations[i] = new AnnotationAdapter(fnAnnotations[i], this);
            }
        } else {
            this.annotations = null;
        }
    }

    public String toString() {
        String str = this.name.getPrefix() != null ? this.name.getPrefix() + ":" + this.name.getLocalPart() : this.name.toString();
        str = str + "#" + this.getArgumentCount();
        return str;
    }

    public QName getName() {
        return this.name;
    }

    private void setName(QName name) {
        this.name = name;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    private void setArgumentCount(int argumentCount) {
        this.argumentCount = argumentCount;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    private void setAnnotations(AnnotationAdapter[] annotations) {
        this.annotations = annotations;
    }

    public FunctionArgument[] getArguments() {
        return this.arguments;
    }

    private void setParameters(FunctionParameterSequenceTypeAdapter[] parameters) {
        this.arguments = parameters;
    }
}

