/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl.xquery.exist;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.extensions.exquery.restxq.impl.ExistXqueryRegistry;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceRegistryManager;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.exquery.ExQueryException;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class RegistryFunctions
extends BasicFunction {
    private static final org.exist.dom.QName qnFindResourceFunctions = new org.exist.dom.QName("find-resource-functions", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnRegisterModule = new org.exist.dom.QName("register-module", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnDeregisterModule = new org.exist.dom.QName("deregister-module", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnRegisterResourceFunction = new org.exist.dom.QName("register-resource-function", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnDeregisterResourceFunction = new org.exist.dom.QName("deregister-resource-function", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnInvalidModules = new org.exist.dom.QName("invalid-modules", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnMissingDependencies = new org.exist.dom.QName("missing-dependencies", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName qnDependencies = new org.exist.dom.QName("dependencies", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final SequenceType PARAM_MODULE = new FunctionParameterSequenceType("module", 25, 2, "A URI pointing to an XQuery module.");
    private static final SequenceType PARAM_RESOURCE_FUNCTION = new FunctionParameterSequenceType("function-signature", 22, 2, "A signature identifying a resource function. Takes the format {namespace}local-name#arity e.g. {http://somenamespace}some-function#2");
    public static final FunctionSignature FNS_REGISTER_MODULE = new FunctionSignature(qnRegisterModule, "Registers all resource functions identified in the XQuery Module with the RestXQ Registry.", new SequenceType[]{PARAM_MODULE}, (SequenceType)new FunctionReturnSequenceType(6, 2, "The list of newly registered resource functions."));
    public static final FunctionSignature FNS_DEREGISTER_MODULE = new FunctionSignature(qnDeregisterModule, "Deregisters all resource functions identified in the XQuery Module from the RestXQ Registry.", new SequenceType[]{PARAM_MODULE}, (SequenceType)new FunctionReturnSequenceType(6, 2, "The list of deregistered resource functions."));
    public static final FunctionSignature FNS_FIND_RESOURCE_FUNCTIONS = new FunctionSignature(qnFindResourceFunctions, "Compiles the XQuery Module and examines it, producing a list of all the declared resource functions.", new SequenceType[]{PARAM_MODULE}, (SequenceType)new FunctionReturnSequenceType(6, 2, "The list of newly registered resource functions."));
    public static final FunctionSignature FNS_REGISTER_RESOURCE_FUNCTION = new FunctionSignature(qnRegisterResourceFunction, "Registers a resource function from the XQuery Module with the RestXQ Registry.", new SequenceType[]{PARAM_MODULE, PARAM_RESOURCE_FUNCTION}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if the function was registered, false otherwise."));
    public static final FunctionSignature FNS_DEREGISTER_RESOURCE_FUNCTION = new FunctionSignature(qnDeregisterResourceFunction, "Deregisters a resource function from the RestXQ Registry.", new SequenceType[]{PARAM_MODULE, PARAM_RESOURCE_FUNCTION}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if the function was deregistered, false otherwise."));
    public static final FunctionSignature FNS_INVALID_MODULES = new FunctionSignature(qnInvalidModules, "Gets a list of all the invalid XQuery modules discovered by RESTXQ in the process of discovering resource functions.", FunctionSignature.NO_ARGS, (SequenceType)new FunctionReturnSequenceType(22, 7, "The list of invalid XQuery modules."));
    public static final FunctionSignature FNS_MISSING_DEPENDENCIES = new FunctionSignature(qnMissingDependencies, "Gets a list of all the missing dependencies for XQuery modules discovered by RESTXQ in the process of discovering resource functions.", FunctionSignature.NO_ARGS, (SequenceType)new FunctionReturnSequenceType(6, 2, "The list of missing dependencies."));
    public static final FunctionSignature FNS_DEPENDENCIES = new FunctionSignature(qnDependencies, "Gets a list of all the dependencies of compiled XQuery modules discovered by RESTXQ in the process of discovering resource functions.", FunctionSignature.NO_ARGS, (SequenceType)new FunctionReturnSequenceType(6, 2, "The list of dependencies."));
    private static final org.exist.dom.QName MISSING_DEPENDENCIES = new org.exist.dom.QName("missing-dependencies", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName MISSING_DEPENDENCY = new org.exist.dom.QName("missing-dependency", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName REQUIRED_BY = new org.exist.dom.QName("required-by", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName DEPENDENCIES = new org.exist.dom.QName("dependencies", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName MODULE = new org.exist.dom.QName("module", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final org.exist.dom.QName REQUIRES = new org.exist.dom.QName("requires", "http://exquery.org/ns/restxq/exist", "exrest");
    private static final String XQUERY_URI = "xquery-uri";

    public RegistryFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ExistXqueryRegistry xqueryRegistry = ExistXqueryRegistry.getInstance();
        RestXqServiceRegistry registry = RestXqServiceRegistryManager.getRegistry(this.getContext().getBroker().getBrokerPool());
        Sequence result = Sequence.EMPTY_SEQUENCE;
        try {
            block39: {
                if (this.isCalledAs(qnRegisterModule.getLocalPart())) {
                    XmldbURI moduleUri = (XmldbURI)args[0].toJavaObject(XmldbURI.class);
                    DocumentImpl module = this.getContext().getBroker().getResource(moduleUri, 4);
                    if (xqueryRegistry.isXquery(module)) {
                        try {
                            List<RestXqService> resourceFunctions = xqueryRegistry.findServices(this.getContext().getBroker(), module);
                            xqueryRegistry.registerServices(this.getContext().getBroker(), resourceFunctions);
                            result = (NodeValue)org.exist.extensions.exquery.restxq.impl.xquery.RegistryFunctions.serializeRestXqServices(this.context.getDocumentBuilder(), resourceFunctions).getDocumentElement();
                        }
                        catch (ExQueryException e) {
                            LOG.warn(e.getMessage(), (Throwable)e);
                            result = Sequence.EMPTY_SEQUENCE;
                        }
                    } else {
                        result = Sequence.EMPTY_SEQUENCE;
                    }
                } else if (this.isCalledAs(qnDeregisterModule.getLocalPart())) {
                    XmldbURI moduleUri = (XmldbURI)args[0].toJavaObject(XmldbURI.class);
                    DocumentImpl module = this.getContext().getBroker().getResource(moduleUri, 4);
                    if (xqueryRegistry.isXquery(module)) {
                        ArrayList<RestXqService> deregisteringServices = new ArrayList<RestXqService>();
                        for (RestXqService service : registry) {
                            if (!XmldbURI.create((URI)service.getResourceFunction().getXQueryLocation()).equals((Object)moduleUri)) continue;
                            deregisteringServices.add(service);
                        }
                        xqueryRegistry.deregisterServices(this.getContext().getBroker(), moduleUri);
                        result = (NodeValue)org.exist.extensions.exquery.restxq.impl.xquery.RegistryFunctions.serializeRestXqServices(this.context.getDocumentBuilder(), deregisteringServices).getDocumentElement();
                    } else {
                        result = Sequence.EMPTY_SEQUENCE;
                    }
                } else if (this.isCalledAs(qnFindResourceFunctions.getLocalPart())) {
                    XmldbURI moduleUri = (XmldbURI)args[0].toJavaObject(XmldbURI.class);
                    DocumentImpl module = this.getContext().getBroker().getResource(moduleUri, 4);
                    if (xqueryRegistry.isXquery(module)) {
                        try {
                            List<RestXqService> resourceFunctions = xqueryRegistry.findServices(this.getContext().getBroker(), module);
                            xqueryRegistry.deregisterServices(this.getContext().getBroker(), moduleUri);
                            result = (NodeValue)org.exist.extensions.exquery.restxq.impl.xquery.RegistryFunctions.serializeRestXqServices(this.context.getDocumentBuilder(), resourceFunctions).getDocumentElement();
                        }
                        catch (ExQueryException e) {
                            LOG.warn(e.getMessage(), (Throwable)e);
                            result = Sequence.EMPTY_SEQUENCE;
                        }
                    } else {
                        result = Sequence.EMPTY_SEQUENCE;
                    }
                } else if (this.isCalledAs(qnRegisterResourceFunction.getLocalPart())) {
                    XmldbURI moduleUri = (XmldbURI)args[0].toJavaObject(XmldbURI.class);
                    String resourceFunctionIdentifier = args[1].getStringValue();
                    DocumentImpl module = this.getContext().getBroker().getResource(moduleUri, 4);
                    if (xqueryRegistry.isXquery(module)) {
                        SignatureDetail signatureDetail = this.extractSignatureDetail(resourceFunctionIdentifier);
                        if (signatureDetail != null) {
                            try {
                                RestXqService serviceToRegister = this.findService(xqueryRegistry.findServices(this.getContext().getBroker(), module).iterator(), signatureDetail);
                                if (serviceToRegister != null) {
                                    xqueryRegistry.registerServices(this.context.getBroker(), Collections.singletonList(serviceToRegister));
                                    result = BooleanValue.TRUE;
                                    break block39;
                                }
                                result = BooleanValue.FALSE;
                            }
                            catch (ExQueryException e) {
                                LOG.warn(e.getMessage(), (Throwable)e);
                                result = BooleanValue.FALSE;
                            }
                        } else {
                            result = BooleanValue.FALSE;
                        }
                    } else {
                        result = Sequence.EMPTY_SEQUENCE;
                    }
                } else if (this.isCalledAs(qnDeregisterResourceFunction.getLocalPart())) {
                    String resourceFunctionIdentifier = args[1].getStringValue();
                    SignatureDetail signatureDetail = this.extractSignatureDetail(resourceFunctionIdentifier);
                    if (signatureDetail != null) {
                        RestXqService serviceToDeregister = this.findService(xqueryRegistry.registered(this.context.getBroker()), signatureDetail);
                        if (serviceToDeregister != null) {
                            xqueryRegistry.deregisterService(this.context.getBroker(), serviceToDeregister);
                            result = BooleanValue.TRUE;
                        } else {
                            result = BooleanValue.FALSE;
                        }
                    } else {
                        result = BooleanValue.FALSE;
                    }
                } else if (this.isCalledAs(qnInvalidModules.getLocalPart())) {
                    result = this.serializeInvalidQueries(xqueryRegistry.getInvalidQueries());
                } else if (this.isCalledAs(qnMissingDependencies.getLocalPart())) {
                    result = this.serializeMissingDependencies(xqueryRegistry.getMissingDependencies());
                } else if (this.isCalledAs(qnDependencies.getLocalPart())) {
                    result = this.serializeDependenciesTree(xqueryRegistry.getDependenciesTree());
                }
            }
            return result;
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, pde.getMessage(), (Throwable)pde);
        }
    }

    private Sequence serializeDependenciesTree(Map<String, Set<String>> dependenciesTree) {
        MemTreeBuilder builder = this.getContext().getDocumentBuilder();
        builder.startDocument();
        builder.startElement(DEPENDENCIES, null);
        for (Map.Entry<String, Set<String>> dependencyTree : dependenciesTree.entrySet()) {
            this.serializeDependencyTree(builder, dependencyTree);
        }
        builder.endElement();
        builder.endDocument();
        return builder.getDocument();
    }

    private void serializeDependencyTree(MemTreeBuilder builder, Map.Entry<String, Set<String>> dependencyTree) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, XQUERY_URI, "", "string", dependencyTree.getKey());
        builder.startElement(MODULE, (Attributes)attrs);
        for (String dependency : dependencyTree.getValue()) {
            attrs = new AttributesImpl();
            attrs.addAttribute(null, XQUERY_URI, "", "string", dependency);
            builder.startElement(REQUIRES, (Attributes)attrs);
            builder.endElement();
        }
        builder.endElement();
    }

    private Sequence serializeMissingDependencies(Map<String, Set<String>> missingDependencies) {
        MemTreeBuilder builder = this.getContext().getDocumentBuilder();
        builder.startDocument();
        builder.startElement(MISSING_DEPENDENCIES, null);
        for (Map.Entry<String, Set<String>> missingDependency : missingDependencies.entrySet()) {
            this.serializeMissingDependency(builder, missingDependency);
        }
        builder.endElement();
        builder.endDocument();
        return builder.getDocument();
    }

    private void serializeMissingDependency(MemTreeBuilder builder, Map.Entry<String, Set<String>> missingDependency) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, XQUERY_URI, "", "string", missingDependency.getKey());
        builder.startElement(MISSING_DEPENDENCY, (Attributes)attrs);
        for (String dependent : missingDependency.getValue()) {
            attrs = new AttributesImpl();
            attrs.addAttribute(null, XQUERY_URI, "", "string", dependent);
            builder.startElement(REQUIRED_BY, (Attributes)attrs);
            builder.endElement();
        }
        builder.endElement();
    }

    private Sequence serializeInvalidQueries(Set<String> invalidQueries) throws XPathException {
        ValueSequence result = new ValueSequence();
        for (String invalidQuery : invalidQueries) {
            result.add((Item)new StringValue(invalidQuery));
        }
        return result;
    }

    private RestXqService findService(Iterator<RestXqService> services, SignatureDetail signatureDetail) {
        RestXqService result = null;
        if (services != null) {
            while (services.hasNext()) {
                RestXqService service = services.next();
                org.exquery.xquery3.FunctionSignature signature = service.getResourceFunction().getFunctionSignature();
                if (!signature.getName().equals(signatureDetail.name) || signature.getArgumentCount() != signatureDetail.arity) continue;
                result = service;
                break;
            }
        }
        return result;
    }

    private SignatureDetail extractSignatureDetail(String resourceFunctionIdentifier) {
        SignatureDetail result = null;
        if (resourceFunctionIdentifier.indexOf(35) > -1) {
            int arity = Integer.parseInt(resourceFunctionIdentifier.substring(resourceFunctionIdentifier.indexOf(35) + 1));
            QName name = resourceFunctionIdentifier.startsWith("{") ? new QName(resourceFunctionIdentifier.substring(1, resourceFunctionIdentifier.indexOf(125))) : new QName(resourceFunctionIdentifier.substring(0, resourceFunctionIdentifier.indexOf(35)), resourceFunctionIdentifier.substring(resourceFunctionIdentifier.indexOf(125)));
            result = new SignatureDetail(name, arity);
        }
        return result;
    }

    private class SignatureDetail {
        final QName name;
        final int arity;

        public SignatureDetail(QName name, int arity) {
            this.name = name;
            this.arity = arity;
        }
    }
}

