/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.expath.pkg.repo.Extension;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.parser.DescriptorParser;
import org.expath.pkg.repo.parser.XMLStreamHelper;

public abstract class DescriptorExtension
extends Extension {
    protected String myDescriptorName;

    public DescriptorExtension(String extension_name, String descriptor_name) {
        super(extension_name);
        this.myDescriptorName = descriptor_name;
    }

    public void init(Repository repo, Package pkg) throws PackageException {
        Source desc;
        try {
            desc = pkg.getResolver().resolveResource(this.myDescriptorName);
        }
        catch (Storage.NotExistException ex) {
            return;
        }
        XMLStreamHelper helper = DescriptorParser.XS_HELPER;
        XMLStreamReader parser = helper.makeParser(desc);
        helper.ensureDocument(parser);
        this.parseDescriptor(parser, pkg);
    }

    protected abstract void parseDescriptor(XMLStreamReader var1, Package var2) throws PackageException;
}

