/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.deps;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.expath.pkg.repo.PackageException;

public class Semver {
    private static final Pattern NUMBER_RE = Pattern.compile("^([1-9][0-9]*)|0$");
    private static final Pattern LAST_PART_RE = Pattern.compile("^(([1-9][0-9]*)|0)[-+]?([a-zA-Z][-a-zA-Z0-9]*)$");
    private String myString;
    private String[] myParts;

    public Semver(String semver) throws PackageException {
        this.myParts = Semver.parse(semver);
        this.myString = semver;
    }

    public boolean matches(Semver rhs) throws PackageException {
        int this_len = this.myParts.length;
        int rhs_len = rhs.myParts.length;
        if (rhs_len < 3) {
            throw new PackageException("RHS is not a SemVer version: '" + rhs.myString + "'");
        }
        if (rhs_len < this_len) {
            return false;
        }
        for (int i = 0; i < this_len; ++i) {
            String p1 = this.myParts[i];
            String p2 = rhs.myParts[i];
            if (p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesMin(Semver rhs) throws PackageException {
        int this_len = this.myParts.length;
        int rhs_len = rhs.myParts.length;
        int max = this_len == 4 ? 3 : this_len;
        for (int i = 0; i < max; ++i) {
            String p1 = this.myParts[i];
            String p2 = rhs.myParts[i];
            int cmp = Semver.compareNumbers(p1, p2);
            if (cmp < 0) {
                return true;
            }
            if (cmp <= 0) continue;
            return false;
        }
        if (this_len < 3) {
            return true;
        }
        if (this_len == 4) {
            if (rhs_len == 4) {
                String p1 = this.myParts[3];
                String p2 = rhs.myParts[3];
                return p1.compareTo(p2) <= 0;
            }
            return true;
        }
        return rhs_len != 4;
    }

    public boolean matchesMax(Semver rhs) throws PackageException {
        int this_len = this.myParts.length;
        int rhs_len = rhs.myParts.length;
        int max = this_len == 4 ? 3 : this_len;
        for (int i = 0; i < max; ++i) {
            String p1 = this.myParts[i];
            String p2 = rhs.myParts[i];
            int cmp = Semver.compareNumbers(p1, p2);
            if (cmp < 0) {
                return false;
            }
            if (cmp <= 0) continue;
            return true;
        }
        if (this_len < 3) {
            return true;
        }
        if (this_len == 4) {
            if (rhs_len == 4) {
                String p1 = this.myParts[3];
                String p2 = rhs.myParts[3];
                return p1.compareTo(p2) >= 0;
            }
            return false;
        }
        if (rhs_len == 4) {
            return true;
        }
        return true;
    }

    private static int compareNumbers(String lhs, String rhs) {
        int rhs_len;
        int lhs_len = lhs.length();
        if (lhs_len < (rhs_len = rhs.length())) {
            return -1;
        }
        if (lhs_len > rhs_len) {
            return 1;
        }
        return lhs.compareTo(rhs);
    }

    static String[] parse(String semver) throws PackageException {
        String[] parts = semver.split("\\.");
        int len = parts.length;
        if (len > 3) {
            Semver.parseError(semver, "too much version parts");
        }
        if (len == 0) {
            Semver.parseError(semver, "no version parts");
        }
        if (!NUMBER_RE.matcher(parts[0]).matches()) {
            Semver.parseError(semver, "first part is not a number");
        }
        if (len == 1) {
            return parts;
        }
        if (!NUMBER_RE.matcher(parts[1]).matches()) {
            Semver.parseError(semver, "second part is not a number");
        }
        if (len == 2) {
            return parts;
        }
        if (NUMBER_RE.matcher(parts[2]).matches()) {
            return parts;
        }
        Matcher m = LAST_PART_RE.matcher(parts[2]);
        if (m.matches()) {
            String[] result = new String[]{parts[0], parts[1], m.group(1), m.group(3)};
            return result;
        }
        Semver.parseError(semver, "third part is invalid");
        return null;
    }

    private static void parseError(String semver, String msg) throws PackageException {
        throw new PackageException("Invalid SemVer pattern '" + semver + "': " + msg);
    }
}

