/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.parser;

import javax.xml.namespace.QName;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.expath.pkg.repo.PackageException;

public class XMLStreamHelper {
    private String myTargetNS;

    public XMLStreamHelper(String targetNS) {
        this.myTargetNS = targetNS;
    }

    public String getTargetNs() {
        return this.myTargetNS;
    }

    public XMLStreamReader makeParser(Source desc) throws PackageException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(desc);
            WhitespaceFilter filter = new WhitespaceFilter();
            return factory.createFilteredReader(reader, filter);
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error parsing the package descriptor", ex);
        }
    }

    public void ensureDocument(XMLStreamReader parser) throws PackageException {
        int event = parser.getEventType();
        if (event != 7) {
            this.stateError("The current event is not START_DOCUMENT", event);
        }
    }

    public boolean isNextElement(XMLStreamReader parser, String local_name) throws PackageException {
        try {
            parser.next();
            return this.isElement(parser, local_name);
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error parsing the package descriptor", ex);
        }
    }

    public void ensureNextElement(XMLStreamReader parser, String local_name) throws PackageException {
        try {
            parser.next();
            this.ensureElement(parser, local_name);
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error parsing the package descriptor", ex);
        }
    }

    public boolean isElement(XMLStreamReader parser, String local_name) throws PackageException {
        int event = parser.getEventType();
        if (event != 1) {
            return false;
        }
        return new QName(this.myTargetNS, local_name).equals(parser.getName());
    }

    public void ensureElement(XMLStreamReader parser, String local_name) throws PackageException {
        int event = parser.getEventType();
        if (event != 1) {
            this.stateError("The current event is not START_ELEMENT", event);
        }
        if (!new QName(this.myTargetNS, local_name).equals(parser.getName())) {
            throw new PackageException("The element is not a pkg:" + local_name);
        }
    }

    public String getEventName(int event) throws PackageException {
        switch (event) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        throw new PackageException("Unknown event code: " + event);
    }

    public String getAttributeValue(XMLStreamReader parser, String name) throws PackageException {
        String value = parser.getAttributeValue(null, name);
        if (value == null) {
            throw new PackageException("The element does not have an attribute " + name);
        }
        return value;
    }

    public String getElementValue(XMLStreamReader parser) throws PackageException {
        return this.accumulateStringValue(parser);
    }

    private String accumulateStringValue(XMLStreamReader parser) throws PackageException {
        StringBuilder buf = new StringBuilder();
        try {
            int event;
            while ((event = parser.next()) != 2) {
                if (event != 4) {
                    this.stateError("Current event is not CHARACTERS", event);
                }
                buf.append(parser.getTextCharacters(), parser.getTextStart(), parser.getTextLength());
            }
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error parsing the package descriptor", ex);
        }
        return buf.toString();
    }

    public void ignoreElement(XMLStreamReader parser) throws PackageException {
        int opened = 1;
        while (opened > 0) {
            try {
                parser.next();
                if (parser.getEventType() == 1) {
                    ++opened;
                    continue;
                }
                if (parser.getEventType() != 2) continue;
                --opened;
            }
            catch (XMLStreamException ex) {
                throw new PackageException("Error reading the package descriptor", ex);
            }
        }
    }

    public boolean stateError(String msg, int event) throws PackageException {
        String event_name = this.getEventName(event);
        throw new PackageException(msg + " (" + event_name + ")");
    }

    private static class WhitespaceFilter
    implements StreamFilter {
        private WhitespaceFilter() {
        }

        public boolean accept(XMLStreamReader parser) {
            int event = parser.getEventType();
            return event != 5 && event != 3 && event != 6 && (event != 4 || !parser.isWhiteSpace());
        }
    }
}

