/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.Version;
import org.expath.pkg.repo.tui.BatchUserInteraction;
import org.expath.pkg.repo.tui.TextUserInteraction;

public class Main {
    private String myRepoDir = null;
    private boolean myVerbose = false;
    private Repository myRepo = null;

    public static void main(String[] args) {
        Main m = new Main();
        m.run(args);
    }

    private void run(String[] args) {
        int consumed = this.parseOptions(args);
        if (consumed == args.length) {
            System.err.println("Missing command");
            System.err.println();
            this.usage(true);
        }
        String cmd = args[consumed];
        if ("help".equals(args[consumed])) {
            this.doHelp(args, consumed + 1);
        } else if ("version".equals(args[consumed])) {
            this.doVersion(args, consumed + 1);
        } else if ("list".equals(args[consumed])) {
            this.doList(args, consumed + 1);
        } else if ("install".equals(args[consumed])) {
            this.doInstall(args, consumed + 1);
        } else if ("remove".equals(args[consumed])) {
            this.doRemove(args, consumed + 1);
        } else if ("create".equals(args[consumed])) {
            this.doCreate(args, consumed + 1);
        } else if ("lookup".equals(args[consumed])) {
            this.doLookup(args, consumed + 1);
        } else {
            System.err.println("Unknown command: " + cmd);
            System.err.println();
            this.usage(true);
        }
    }

    private int parseOptions(String[] args) {
        int i;
        for (i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("--")) {
                return i + 1;
            }
            if (!a.startsWith("-")) {
                return i;
            }
            if (a.equals("--repo") || a.equals("-r")) {
                this.myRepoDir = args[++i];
                continue;
            }
            if (a.equals("--verbose") || a.equals("-v")) {
                this.myVerbose = true;
                continue;
            }
            System.err.println("Unknown option: " + a);
            System.err.println();
            this.usage(true);
        }
        return i;
    }

    private void setRepo() {
        try {
            this.myRepo = Repository.makeDefaultRepo(this.myRepoDir);
        }
        catch (PackageException ex) {
            System.err.println("Error instantiating the repo: " + ex.getMessage());
            if (this.myVerbose) {
                ex.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private Repository requireRepo() {
        if (this.myRepo == null) {
            this.setRepo();
            if (this.myRepo == null) {
                System.err.println("The repository is not set");
                System.exit(1);
            }
        }
        return this.myRepo;
    }

    private void usage(boolean error) {
        System.err.println("Usage:");
        System.err.println("  xrepo [--repo <repo>|--verbose] help|list|install|remove|create|lookup ...");
        System.err.println();
        System.err.println("Commands:");
        System.err.println("  help");
        System.err.println("  version");
        System.err.println("  list");
        System.err.println("  install [-b|-f] <pkg>");
        System.err.println("      -b batch operations (no interaction)");
        System.err.println("      -f override a package if already installed (force)");
        System.err.println("  remove [-b] <pkg> <version?>");
        System.err.println("      -b batch operations (no interaction)");
        System.err.println("  create <repo>");
        System.err.println("  lookup <space> <uri>");
        System.exit(error ? 1 : 0);
    }

    private void doHelp(String[] args, int consumed) {
        this.checkParams("Help", args, consumed, new String[0]);
        this.usage(false);
    }

    private void doVersion(String[] args, int consumed) {
        this.checkParams("Version", args, consumed, new String[0]);
        Version v = Version.instance();
        v.display(System.out);
    }

    private void doList(String[] args, int consumed) {
        this.checkParams("List", args, consumed, new String[0]);
        Repository repo = this.requireRepo();
        for (Packages pp : repo.listPackages()) {
            System.out.println(pp.name());
            for (Package p : pp.packages()) {
                System.out.println("  " + p.getVersion() + ", in " + p.getResolver().getResourceName());
            }
        }
    }

    private void doInstall(String[] args, int consumed) {
        try {
            boolean force = false;
            UserInteractionStrategy interact = null;
            while (args[consumed].startsWith("-")) {
                if (args[consumed].equals("-b")) {
                    ++consumed;
                    interact = new BatchUserInteraction();
                    continue;
                }
                if (!args[consumed].equals("-f")) break;
                ++consumed;
                force = true;
            }
            if (interact == null) {
                interact = new TextUserInteraction(this.myVerbose);
            }
            Repository repo = this.requireRepo();
            URI uri = this.getURI(args[consumed]);
            if (uri == null) {
                File f = new File(args[consumed]);
                repo.installPackage(f, force, interact);
            } else {
                repo.installPackage(uri, force, interact);
            }
        }
        catch (PackageException ex) {
            System.err.println("Error installing the package: " + ex.getMessage());
            if (this.myVerbose) {
                ex.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private void doRemove(String[] args, int consumed) {
        try {
            boolean force = false;
            UserInteractionStrategy interact = null;
            while (args[consumed].startsWith("-") && args[consumed].equals("-b")) {
                ++consumed;
                interact = new BatchUserInteraction();
            }
            if (interact == null) {
                interact = new TextUserInteraction(this.myVerbose);
            }
            if (consumed >= args.length) {
                throw new PackageException("Package name is required");
            }
            Repository repo = this.requireRepo();
            String pkg = args[consumed++];
            if (consumed < args.length) {
                String version = args[consumed++];
                if (consumed < args.length) {
                    throw new PackageException("Extra options given to command remove");
                }
                repo.removePackage(pkg, version, force, interact);
            } else {
                repo.removePackage(pkg, force, interact);
            }
        }
        catch (PackageException ex) {
            System.err.println("Error removing the package: " + ex.getMessage());
            if (this.myVerbose) {
                ex.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private void doCreate(String[] args, int consumed) {
        this.checkParams("Create", args, consumed, "repository directory name");
        File repo_dir = new File(args[consumed]);
        try {
            Repository.createRepository(repo_dir);
        }
        catch (PackageException ex) {
            System.err.println("Error creating the repository: " + ex.getMessage());
            if (this.myVerbose) {
                ex.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private void doLookup(String[] args, int consumed) {
        this.checkParams("Lookup", args, consumed, "URI space", "URI");
        try {
            URISpace space = URISpace.valueOf(args[consumed].toUpperCase());
            String uri = args[consumed + 1];
            Repository repo = this.requireRepo();
            Source resolved = repo.resolve(uri, space);
            if (resolved == null) {
                System.out.println("not found");
            } else {
                System.out.println(resolved.getSystemId());
            }
        }
        catch (PackageException ex) {
            System.err.println("Error configuring the repository: " + ex.getMessage());
            if (this.myVerbose) {
                ex.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private void checkParams(String cmd, String[] args, int consumed, String ... params) {
        if (args.length > consumed + params.length) {
            System.err.println(cmd + ": too much parameters");
            System.err.println();
            this.usage(true);
        }
        for (int i = 0; i < params.length; ++i) {
            if (consumed + i != args.length) continue;
            System.err.println(cmd + ": missing " + params[i]);
            System.err.println();
            this.usage(true);
        }
    }

    private URI getURI(String s) {
        URI uri;
        try {
            uri = new URI(s);
        }
        catch (URISyntaxException ex) {
            return null;
        }
        if (uri.isAbsolute()) {
            return uri;
        }
        return null;
    }
}

