/*
 * Decompiled with CFR 0.152.
 */
package org.exist.exiftool.xquery;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NativeBroker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class MetadataFunctions
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(MetadataFunctions.class);
    public static final FunctionSignature getMetadata = new FunctionSignature(new QName("get-metadata", "http://exist-db.org/xquery/exiftool", "exiftool"), "extracts the metadata", new SequenceType[]{new FunctionParameterSequenceType("binary", 25, 2, "The binary file from which to extract from")}, (SequenceType)new FunctionReturnSequenceType(6, 2, "Extracted metadata"));

    public MetadataFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String uri = args[0].itemAt(0).getStringValue();
        try {
            if (uri.toLowerCase().startsWith("http")) {
                return this.extractMetadataFromWebResource(uri);
            }
            XmldbURI docUri = XmldbURI.xmldbUriFor((String)uri);
            return this.extractMetadataFromLocalResource(docUri);
        }
        catch (URISyntaxException use) {
            throw new XPathException("Could not parse document URI: " + use.getMessage(), (Throwable)use);
        }
    }

    private Sequence extractMetadataFromLocalResource(XmldbURI docUri) throws XPathException {
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(docUri, Lock.LockMode.READ_LOCK);
            if (doc instanceof BinaryDocument) {
                Path binaryFile = ((NativeBroker)this.context.getBroker()).getCollectionBinaryFileFsPath(docUri);
                if (!Files.exists(binaryFile, new LinkOption[0])) {
                    throw new XPathException("Binary Document at " + docUri.toString() + " does not exist.");
                }
                Sequence sequence = this.exifToolExtract(binaryFile);
                return sequence;
            }
            try {
                throw new XPathException("The binay document at " + docUri.toString() + " cannot be found.");
            }
            catch (PermissionDeniedException pde) {
                throw new XPathException("Could not access binary document: " + pde.getMessage(), (Throwable)pde);
            }
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }

    private Sequence extractMetadataFromWebResource(String uri) throws XPathException {
        try {
            URI u = new URI(uri);
            return this.exifToolWebExtract(u);
        }
        catch (URISyntaxException ex) {
            throw new XPathException("URI syntax error" + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private Sequence exifToolExtract(Path binaryFile) throws XPathException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Sequence exifToolWebExtract(URI uri) throws XPathException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

