/*
 * Decompiled with CFR 0.152.
 */
package org.xqdoc.conversion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.xqdoc.conversion.XQDocComment;
import org.xqdoc.conversion.XQDocPayload;
import org.xqdoc.conversion.XQDocXML;

public class XQDocContext {
    public static final String XQDOC_NAMESPACE = "http://www.xqdoc.org/1.0";
    private static final String XQDOC_VERSION = "1.0";
    private XQDocXML xqDocXML;
    private HashMap predefinedFunctionNamespaces;
    private String defaultFunctionNamespace;
    private String moduleBase;
    private String commonName;
    private String moduleBody;
    private boolean encodeURIs = false;
    private String moduleURI;
    private HashMap uriModuleMap = new HashMap();
    private String defaultModuleFunctionNamespace;
    private HashSet invokedFunctions = new HashSet();
    private HashSet referencedVariables = new HashSet();
    private String functionName;
    private boolean functionPrefixSet = false;
    private boolean mainModuleFound = false;
    private String functionSignature;
    private String functionBody;
    private XQDocComment xqDocComment = new XQDocComment();

    public XQDocContext(String namespace) {
    }

    public void init(String base, String name, String source, HashMap map, String uri, boolean encode) {
        this.moduleBase = base;
        this.commonName = name;
        this.moduleBody = source;
        this.predefinedFunctionNamespaces = map != null ? (HashMap)map.clone() : new HashMap();
        this.defaultFunctionNamespace = uri;
        this.encodeURIs = encode;
        this.xqDocXML = new XQDocXML(XQDOC_NAMESPACE);
        this.xqDocComment.clear();
        this.invokedFunctions = new HashSet();
        this.referencedVariables = new HashSet();
        this.xqDocXML.buildControlSection(XQDOC_VERSION);
        this.uriModuleMap = new HashMap();
        this.defaultModuleFunctionNamespace = null;
        this.mainModuleFound = false;
        this.functionPrefixSet = false;
    }

    public void buildLibraryModuleSection(String uri) {
        this.moduleURI = uri;
        if (this.encodeURIs) {
            this.moduleURI = this.encodeURI(this.moduleURI);
        }
        this.xqDocXML.buildLibraryModuleSection(this.moduleURI, this.commonName, this.xqDocComment, this.moduleBody);
        this.xqDocComment.clear();
    }

    public void buildMainModuleSection() {
        String newUri = this.commonName;
        if (this.moduleBase != null) {
            newUri = String.valueOf(this.moduleBase) + "/" + this.commonName;
        }
        this.moduleURI = newUri;
        if (this.encodeURIs) {
            this.moduleURI = this.encodeURI(this.moduleURI);
        }
        this.xqDocXML.buildMainModuleSection(this.moduleURI, this.commonName, this.xqDocComment, this.moduleBody);
        this.xqDocComment.clear();
        this.mainModuleFound = true;
    }

    public void buildImportSection(String uri) {
        if (this.encodeURIs) {
            this.xqDocXML.buildImportSection(this.encodeURI(uri), this.xqDocComment);
        } else {
            this.xqDocXML.buildImportSection(uri, this.xqDocComment);
        }
        this.xqDocComment.clear();
    }

    public void buildVariableSection(String uri) {
        this.xqDocXML.buildVariableSection(uri, this.xqDocComment);
        this.xqDocComment.clear();
        this.invokedFunctions = new HashSet();
        this.referencedVariables = new HashSet();
    }

    public void buildFunctionSection() {
        this.xqDocXML.buildFunctionSection(this.functionName, this.functionSignature, this.xqDocComment, this.functionBody, this.invokedFunctions, this.referencedVariables);
        this.xqDocComment.clear();
        this.invokedFunctions = new HashSet();
        this.referencedVariables = new HashSet();
    }

    public XQDocPayload buildResponse() {
        XQDocPayload payload = new XQDocPayload();
        payload.setXQDocXML(this.xqDocXML.getXML());
        payload.setModuleURI(this.moduleURI);
        return payload;
    }

    public void addPrefixAndURI(String prefix, String uri) {
        this.uriModuleMap.put(prefix, uri);
    }

    public void setDefaultModuleFunctionNamespace(String uri) {
        this.defaultModuleFunctionNamespace = uri;
    }

    public void setFunctionName(String prefix, String name) {
        if (!this.functionPrefixSet && this.mainModuleFound) {
            this.functionPrefixSet = true;
            if (prefix == null) {
                if (this.defaultModuleFunctionNamespace != null) {
                    this.adjustNamespaceMapping(this.defaultModuleFunctionNamespace);
                    this.defaultModuleFunctionNamespace = this.moduleURI;
                } else if (this.defaultFunctionNamespace != null) {
                    this.adjustNamespaceMapping(this.defaultFunctionNamespace);
                    this.defaultFunctionNamespace = this.moduleURI;
                }
            } else {
                String tmp = (String)this.uriModuleMap.get(prefix);
                if (tmp != null) {
                    this.adjustDefaultNamespace(tmp);
                    this.adjustNamespaceMapping(tmp);
                }
                if ((tmp = (String)this.predefinedFunctionNamespaces.get(prefix)) != null) {
                    this.adjustDefaultNamespace(tmp);
                    this.adjustNamespaceMapping(tmp);
                }
            }
        }
        this.functionName = name;
    }

    private void adjustNamespaceMapping(String uri) {
        String tmp;
        Set ks = this.uriModuleMap.keySet();
        for (String key : ks) {
            tmp = (String)this.uriModuleMap.get(key);
            if (!tmp.equals(uri)) continue;
            this.uriModuleMap.put(key, this.moduleURI);
        }
        ks = this.predefinedFunctionNamespaces.keySet();
        for (String key : ks) {
            tmp = (String)this.predefinedFunctionNamespaces.get(key);
            if (!tmp.equals(uri)) continue;
            this.predefinedFunctionNamespaces.put(key, this.moduleURI);
        }
    }

    private void adjustDefaultNamespace(String uri) {
        if (this.defaultModuleFunctionNamespace != null && uri.equals(this.defaultModuleFunctionNamespace)) {
            this.defaultModuleFunctionNamespace = this.moduleURI;
        }
        if (this.defaultFunctionNamespace != null && uri.equals(this.defaultFunctionNamespace)) {
            this.defaultFunctionNamespace = this.moduleURI;
        }
    }

    public void setFunctionSignature(String signature) {
        this.functionSignature = signature;
    }

    public void setFunctionBody(String body) {
        this.functionBody = body;
    }

    public void setXQDocBuffer(String text) {
        this.xqDocComment.setComment(text);
    }

    public void setInvokedFunction(String fName) {
        String namespacePrefix = null;
        String namespace = null;
        String localName = null;
        String[] tmp = fName.split(":", 2);
        if (tmp.length > 1) {
            namespacePrefix = tmp[0];
            localName = tmp[1];
        } else {
            localName = tmp[0];
        }
        if (namespacePrefix == null) {
            if (this.defaultModuleFunctionNamespace != null) {
                namespace = this.defaultModuleFunctionNamespace;
            } else if (this.defaultFunctionNamespace != null) {
                namespace = this.defaultFunctionNamespace;
            }
        } else {
            namespace = (String)this.uriModuleMap.get(namespacePrefix);
            if (namespace == null) {
                namespace = (String)this.predefinedFunctionNamespaces.get(namespacePrefix);
            }
        }
        if (namespace == null) {
            return;
        }
        if (this.encodeURIs) {
            namespace = this.encodeURI(namespace);
        }
        if (!this.invokedFunctions.contains(String.valueOf(namespace) + " " + localName)) {
            this.invokedFunctions.add(String.valueOf(namespace) + " " + localName);
        }
    }

    public void setReferencedVariable(String vName) {
        String namespacePrefix = null;
        String namespace = null;
        String localName = null;
        String[] tmp = vName.split(":", 2);
        if (tmp.length <= 1) {
            return;
        }
        namespacePrefix = tmp[0];
        localName = tmp[1];
        namespace = (String)this.uriModuleMap.get(namespacePrefix);
        if (namespace == null) {
            namespace = (String)this.predefinedFunctionNamespaces.get(namespacePrefix);
        }
        if (namespace == null) {
            return;
        }
        if (this.encodeURIs) {
            namespace = this.encodeURI(namespace);
        }
        if (!this.referencedVariables.contains(String.valueOf(namespace) + " " + localName)) {
            this.referencedVariables.add(String.valueOf(namespace) + " " + localName);
        }
    }

    private String encodeURI(String uri) {
        return uri.replaceAll("/", "~2F");
    }
}

