/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.realm.activedirectory;

import java.util.HashMap;
import java.util.Optional;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.config.Configuration;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.security.AbstractAccount;
import org.exist.security.Account;
import org.exist.security.AuthenticationException;
import org.exist.security.Subject;
import org.exist.security.internal.SecurityManagerImpl;
import org.exist.security.internal.SubjectAccreditedImpl;
import org.exist.security.internal.aider.UserAider;
import org.exist.security.realm.activedirectory.ContextFactory;
import org.exist.security.realm.ldap.LDAPRealm;
import org.exist.security.realm.ldap.LdapContextFactory;
import org.exist.storage.DBBroker;

@ConfigurationClass(value="realm")
public class ActiveDirectoryRealm
extends LDAPRealm {
    private static final Logger LOG = LogManager.getLogger(LDAPRealm.class);
    @ConfigurationFieldAsAttribute(value="id")
    public static String ID = "ActiveDirectory";
    @ConfigurationFieldAsAttribute(value="version")
    public static final String version = "1.0";

    public ActiveDirectoryRealm(SecurityManagerImpl sm, Configuration config) {
        super(sm, config);
    }

    protected LdapContextFactory ensureContextFactory() {
        if (this.ldapContextFactory == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No LdapContextFactory specified - creating a default instance.");
            }
            ContextFactory factory = new ContextFactory(this.configuration);
            this.ldapContextFactory = factory;
        }
        return this.ldapContextFactory;
    }

    public String getId() {
        return ID;
    }

    public Subject authenticate(String username, Object credentials) throws AuthenticationException {
        String[] returnedAtts = new String[]{"sn", "givenName", "mail"};
        String searchFilter = "(&(objectClass=user)(sAMAccountName=" + username + "))";
        SearchControls searchCtls = new SearchControls();
        searchCtls.setReturningAttributes(returnedAtts);
        searchCtls.setSearchScope(2);
        LdapContext ctxGC = null;
        boolean ldapUser = false;
        try {
            ctxGC = this.ensureContextFactory().getLdapContext(username, String.valueOf(credentials));
            NamingEnumeration<SearchResult> answer = ctxGC.search(((ContextFactory)this.ensureContextFactory()).getSearchBase(), searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                HashMap<String, Object> amap = null;
                if (attrs == null) continue;
                amap = new HashMap<String, Object>();
                NamingEnumeration<? extends Attribute> ne = attrs.getAll();
                while (ne.hasMore()) {
                    Attribute attr = ne.next();
                    amap.put(attr.getID(), attr.get());
                    ldapUser = true;
                }
                ne.close();
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new AuthenticationException(-1, e.getMessage());
        }
        if (ldapUser) {
            AbstractAccount account = (AbstractAccount)this.getAccount(username);
            if (account == null) {
                try (DBBroker broker = this.getDatabase().get(Optional.of(this.getSecurityManager().getSystemSubject()));){
                    account = (AbstractAccount)this.getSecurityManager().addAccount((Account)new UserAider(ID, username));
                }
                catch (Exception e) {
                    throw new AuthenticationException(-1, e.getMessage(), (Throwable)e);
                }
            }
            return new SubjectAccreditedImpl(account, (Object)ctxGC);
        }
        return null;
    }
}

