/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sort;

import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.sort.SortIndex;
import org.exist.indexing.sort.SortIndexWorker;
import org.exist.util.LockException;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetIndex
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("index", "http://exist-db.org/xquery/sort", "sort"), "Look up a node in the sort index and return a number (&gt; 0) corresponding to the position of that node in the ordered set which was created by a previous call to the sort:create-index function. The function returns the empty sequence if the node cannot be found in the index.", new SequenceType[]{new FunctionParameterSequenceType("id", 22, 2, "The name of the index."), new FunctionParameterSequenceType("node", -1, 3, "The node to look up.")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "A number &gt; 0 or the empty sequence if the $node argument was empty or the node could not be found in the index."));

    public GetIndex(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String id = args[0].getStringValue();
        NodeProxy node = (NodeProxy)args[1].itemAt(0);
        SortIndexWorker index = (SortIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(SortIndex.ID);
        long pos = 0L;
        try {
            pos = index.getIndex(id, node);
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new XPathException((Expression)this, "Caught lock error while searching index. Giving up.", (Throwable)e);
        }
        return pos < 0L ? Sequence.EMPTY_SEQUENCE : new IntegerValue(pos, 37);
    }
}

