/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.bayeux;

import dojox.cometd.Bayeux;
import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.Listener;
import dojox.cometd.Message;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.bayeux.BayeuxScriptConduit;
import org.directwebremoting.dwrp.CallBatch;
import org.directwebremoting.dwrp.PlainCallHandler;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptConduit;

public class BayeuxClient
implements Listener {
    private static final boolean JSON_OUTPUT = false;
    private final Bayeux bayeux;
    private Client client;
    private Remoter remoter;
    private ConverterManager converterManager;
    private PlainCallHandler plainCallHandler;
    private static final Log log = LogFactory.getLog(BayeuxClient.class);

    public BayeuxClient(Bayeux bayeux) {
        this.bayeux = bayeux;
        Channel channel = bayeux.getChannel("/dwr", true);
        channel.subscribe(this.client);
    }

    public void deliver(Client fromClient, Client toClient, Message message) {
        try {
            HashMap<String, FormField> fileParams = new HashMap<String, FormField>(message.size());
            for (Map.Entry entry : message.entrySet()) {
                String param = (String)entry.getValue();
                FormField formField = new FormField(param);
                fileParams.put((String)entry.getKey(), formField);
            }
            CallBatch batch = new CallBatch(fileParams, false);
            Calls calls = this.plainCallHandler.marshallInbound(batch);
            log.debug((Object)("Calls=" + calls));
            for (int i = 0; i < calls.getCallCount(); ++i) {
                Call call = calls.getCall(i);
                Object[] params = call.getParameters();
                log.debug((Object)("Call[" + i + "]=" + call.getScriptName() + "." + call.getMethodName() + (params == null ? "[]" : Arrays.asList(params))));
            }
            Replies replies = this.remoter.execute(calls);
            BayeuxScriptConduit conduit = new BayeuxScriptConduit(this.converterManager, false);
            for (Reply reply : replies) {
                ScriptBuffer script;
                String batchId = calls.getBatchId();
                log.debug((Object)("Reply=" + reply + " BatchId=" + batchId));
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    script = EnginePrivate.getRemoteHandleExceptionScript(batchId, reply.getCallId(), ex);
                    ((ScriptConduit)conduit).addScript(script);
                    log.warn((Object)("--Erroring: batchId[" + batchId + "] message[" + ex.toString() + ']'));
                    continue;
                }
                Object data = reply.getReply();
                log.debug((Object)("data=" + data));
                script = EnginePrivate.getRemoteHandleCallbackScript(batchId, reply.getCallId(), data);
                ((ScriptConduit)conduit).addScript(script);
            }
            String output = ((ScriptConduit)conduit).toString();
            log.debug((Object)("<< " + output));
            Channel channel = this.bayeux.getChannel("/dwr" + fromClient.getId(), true);
            channel.publish(this.client, (Object)output, calls.getBatchId());
        }
        catch (Exception ex) {
            log.warn((Object)"Protocol Error", (Throwable)ex);
        }
    }

    public void removed(String clientId, boolean timeout) {
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setPlainCallHandler(PlainCallHandler plainCallHandler) {
        this.plainCallHandler = plainCallHandler;
    }
}

