/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.directwebremoting.extend.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticCreator
extends AbstractCreator
implements Creator {
    private Class<?> clazz;
    private String instanceMethodName = "getInstance";

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
            if (this.getJavascript() == null) {
                this.setJavascript(this.clazz.getSimpleName());
            }
        }
        catch (ExceptionInInitializerError ex) {
            throw new IllegalArgumentException("Error loading class: " + classname, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found: " + classname, ex);
        }
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        try {
            Method getInstanceMethod = this.clazz.getDeclaredMethod(this.instanceMethodName, new Class[0]);
            return getInstanceMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new InstantiationException("Illegal Access to default constructor on " + this.clazz.getName());
        }
        catch (NoSuchMethodException ex) {
            throw new InstantiationException("The getInstance method specified " + this.instanceMethodName + " does not exist for " + this.clazz.getName());
        }
        catch (InvocationTargetException ex) {
            throw new InstantiationException("An exception occurred while calling the getInstanceMethod " + this.instanceMethodName + " on " + this.clazz.getName());
        }
    }

    public String getInstanceMethodName() {
        return this.instanceMethodName;
    }

    public void setInstanceMethodName(String instanceMethodName) {
        this.instanceMethodName = instanceMethodName;
    }

    public void setClassName(String className) {
        this.setClass(className);
    }

    public String getClassName() {
        return this.getType().getName();
    }
}

