/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreator
implements Creator {
    private boolean hidden = false;
    private boolean cacheable = false;
    private String javascript = null;
    private boolean javascriptInferred = false;
    private String scope = "page";
    private static final Log log = LogFactory.getLog(AbstractCreator.class);

    @Override
    public void setProperties(Map<String, String> params) throws IllegalArgumentException {
    }

    @Override
    public String getJavascript() {
        if (!this.javascriptInferred) {
            this.javascript = LocalUtil.inferWildcardReplacements(this.getType().getName(), this.javascript);
        }
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        if (!LocalUtil.isValidScriptName(javascript)) {
            log.error((Object)("Illegal identifier: '" + javascript + "'"));
            throw new IllegalArgumentException("Illegal identifier");
        }
        this.javascript = javascript;
        this.javascriptInferred = false;
    }

    public void setScope(String scope) {
        AbstractCreator.checkScope(scope);
        this.scope = scope;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    protected static void checkScope(String cscope) {
        if (!(cscope.equals("script") || cscope.equals("page") || cscope.equals("request") || cscope.equals("session") || cscope.equals("application"))) {
            throw new IllegalArgumentException("Illegal scope '" + cscope + "'. application, session, request, script or page required.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJavascript() + "]";
    }
}

