/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.util.JavascriptUtil;

public class EnginePrivate {
    public static String remoteBeginWrapper(String instanceId, boolean useWindowParent) {
        StringBuilder buf = new StringBuilder();
        buf.append("(function(){\n");
        if (useWindowParent) {
            buf.append("try{\n");
            buf.append("var r=window.parent.dwr._[" + instanceId + "];\n");
        } else {
            buf.append("var r=window.dwr._[" + instanceId + "];\n");
        }
        return buf.toString();
    }

    public static String remoteEndWrapper(String instanceId, boolean useWindowParent) {
        StringBuilder buf = new StringBuilder();
        if (useWindowParent) {
            buf.append("} catch(ex) {if (!(ex.number && ex.number == -2146823277)) { throw ex; }}\n");
        }
        buf.append("})();\n");
        return buf.toString();
    }

    public static ScriptBuffer getRemoteHandleCallbackScript(String batchId, String callId, Object data) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleCallback", batchId, callId, data);
        return script;
    }

    public static ScriptBuffer getRemoteHandleExceptionScript(String batchId, String callId, Throwable ex) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleException", batchId, callId, ex);
        return script;
    }

    public static ScriptBuffer getRemoteHandleNewWindowNameScript(String windowName) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleNewWindowName", windowName);
        return script;
    }

    public static String getRemoteHandleBatchExceptionScript(String batchId, Exception ex) {
        StringBuffer reply = new StringBuffer();
        String output = JavascriptUtil.escapeJavaScript(ex.getMessage());
        String params = "{ name:'" + ex.getClass().getName() + "', message:'" + output + "' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("r.handleBatchException(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static ScriptBuffer getRemoteExecuteFunctionScript(String id, Object[] params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleFunctionCall", id, params);
        return script;
    }

    public static ScriptBuffer getRemoteExecuteObjectScript(String id, String methodName, Object[] params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleObjectCall", id, methodName, params);
        return script;
    }

    public static ScriptBuffer getRemoteSetObjectScript(String id, String propertyName, Object data) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleSetCall", id, propertyName, data);
        return script;
    }

    public static ScriptBuffer getRemoteCloseFunctionScript(String id) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("r.handleFunctionClose", id);
        return script;
    }

    public static String getRemotePollCometDisabledScript(String batchId) {
        StringBuffer reply = new StringBuffer();
        String params = "{ name:'dwr.engine.pollAndCometDisabled', message:'Polling and Comet are disabled. See the server logs.' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("r.pollCometDisabled(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static String remoteNewObjectFunction() {
        return "r.newObject";
    }

    public static String xmlStringToJavascriptDomElement(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "r.toDomElement(\"" + xmlout + "\")";
    }

    public static String xmlStringToJavascriptDomDocument(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "r.toDomDocument(\"" + xmlout + "\")";
    }

    public static String getRequireEngineScript() {
        return "if (typeof dwr == 'undefined' || dwr.engine == undefined) throw new Error('You must include DWR engine before including this file');\n";
    }

    public static String getExecuteFunctionName() {
        return "dwr.engine._execute";
    }

    public static String remoteBeginIFrameResponse(String batchId, boolean useWindowParent) {
        return "r.beginIFrameResponse(this.frameElement" + (batchId == null ? "" : ", '" + batchId + "'") + ");";
    }

    public static String remoteEndIFrameResponse(String batchId, boolean useWindowParent) {
        return "r.endIFrameResponse(" + (batchId == null ? "" : "'" + batchId + "'") + ");";
    }

    public static String remoteEval(String script) {
        return "r._eval(\"var r=dwr._[dwr.engine._instanceId]; " + JavascriptUtil.escapeJavaScript(script) + "\");";
    }

    public static ScriptBuffer createForeignWindowProxy(String windowName, ScriptBuffer original) {
        String proxy = JavascriptUtil.escapeJavaScript(original.toString());
        ScriptBuffer reply = new ScriptBuffer();
        reply.appendCall("r.handleForeign", windowName, proxy);
        reply.appendData(proxy);
        return reply;
    }
}

