/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDeclaration {
    private final String moduleName;
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Type[] genericParameterTypes;
    private final boolean varArgs;
    private final Class<?> returnType;
    private final Type genericReturnType;

    public MethodDeclaration(Method method) {
        this(method.getDeclaringClass().getName(), method.getName(), method.getGenericParameterTypes(), method.isVarArgs(), method.getGenericReturnType());
    }

    public MethodDeclaration(String moduleName, String methodName, Type[] genericParameterTypes, boolean varArgs, Type genericReturnType) {
        this.moduleName = moduleName;
        this.methodName = methodName;
        this.genericParameterTypes = genericParameterTypes;
        this.varArgs = varArgs;
        this.genericReturnType = genericReturnType;
        this.parameterTypes = new Class[genericParameterTypes.length];
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            this.parameterTypes[i] = LocalUtil.toClass(genericParameterTypes[i], this.toString());
        }
        this.returnType = LocalUtil.toClass(genericReturnType, this.toString());
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getName() {
        return this.methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type[] getGenericParameterTypes() {
        return this.genericParameterTypes;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    public boolean equals(Object obj) {
        MethodDeclaration other = (MethodDeclaration)obj;
        if (this.moduleName != other.moduleName || this.methodName != other.methodName || this.parameterTypes.length != other.parameterTypes.length || this.returnType != other.returnType) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i] == other.parameterTypes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.moduleName.hashCode() ^ this.methodName.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.methodName + "(");
        boolean first = true;
        for (Type p : this.genericParameterTypes) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(p.toString());
            first = false;
        }
        buf.append(")");
        return buf.toString();
    }
}

