/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Module;
import com.google.inject.binder.ConstantBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.guice.ConvertingImpl;
import org.directwebremoting.guice.DwrGuiceServletModule;
import org.directwebremoting.guice.FilteringImpl;
import org.directwebremoting.guice.InitParamImpl;
import org.directwebremoting.guice.InternalConverter;
import org.directwebremoting.guice.ParamName;
import org.directwebremoting.guice.RemotedImpl;
import org.directwebremoting.guice.util.AbstractModule;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDwrModule
extends AbstractModule {
    volatile Boolean bindPotentiallyConflictingTypes = null;
    private static final AtomicLong unique = new AtomicLong();
    private static final ThreadLocal<Boolean> boundDwrScopes = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    protected abstract void configure();

    protected final void bindPotentiallyConflictingTypes(boolean newBindPotentiallyConflictingTypes) {
        this.bindPotentiallyConflictingTypes = newBindPotentiallyConflictingTypes;
    }

    protected void bindDwrScopes() {
        if (this.bindPotentiallyConflictingTypes == null) {
            this.bindDwrScopes(!AbstractDwrModule.guiceServletModuleExists());
        } else {
            this.bindDwrScopes(this.bindPotentiallyConflictingTypes);
        }
    }

    protected void bindDwrScopes(boolean newBindPotentiallyConflictingTypes) {
        if (!boundDwrScopes.get().booleanValue()) {
            boundDwrScopes.set(true);
            this.install((Module)new DwrGuiceServletModule(newBindPotentiallyConflictingTypes));
        }
    }

    protected void bindAnnotatedClasses(Class<?> ... classes) {
        this.bind(List.class).annotatedWith((Annotation)new InitParamImpl(ParamName.CLASSES, unique.incrementAndGet())).toInstance(Arrays.asList(classes));
    }

    protected <T> LinkedBindingBuilder<T> bindRemoted(Class<T> type) {
        return this.bind(type).annotatedWith((Annotation)new RemotedImpl());
    }

    protected <T> LinkedBindingBuilder<T> bindRemotedAs(String scriptName, Class<T> type) {
        return this.bind(type).annotatedWith((Annotation)new RemotedImpl(scriptName));
    }

    protected LinkedBindingBuilder<Converter> bindConversion(String match) {
        return this.bind(Converter.class).annotatedWith((Annotation)new ConvertingImpl(match));
    }

    protected LinkedBindingBuilder<Converter> bindConversion(Class<?> type) {
        return this.bind(Converter.class).annotatedWith((Annotation)new ConvertingImpl(type));
    }

    protected <T> void bindConversion(Class<T> type, Class<? extends T> impl) {
        this.bind(Converter.class).annotatedWith((Annotation)new ConvertingImpl(type, impl)).to(InternalConverter.class);
    }

    protected LinkedBindingBuilder<AjaxFilter> bindFilter(String scriptName) {
        return this.bind(AjaxFilter.class).annotatedWith((Annotation)new FilteringImpl(scriptName, unique.incrementAndGet()));
    }

    protected LinkedBindingBuilder<AjaxFilter> bindGlobalFilter() {
        return this.bind(AjaxFilter.class).annotatedWith((Annotation)new FilteringImpl("", unique.incrementAndGet()));
    }

    protected ConstantBindingBuilder bindParameter(ParamName paramName) {
        return this.bindConstant().annotatedWith((Annotation)new InitParamImpl(paramName));
    }

    private static boolean guiceServletModuleExists() {
        try {
            LocalUtil.classForName("com.google.inject.servlet.ServletModule");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

