/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.prefs.Preferences;
import org.directwebremoting.guice.AbstractDwrGuiceServletContextListener;
import org.directwebremoting.guice.AbstractDwrModule;

public abstract class DwrGuiceServletContextListener
extends AbstractDwrGuiceServletContextListener {
    private static final Class<?> PACKAGE = DwrGuiceServletContextListener.class;
    private static final String STAGE_KEY = "stage";

    protected final Injector createInjector() {
        return Guice.createInjector((Stage)this.getStage(), (Module[])new Module[]{new DwrScopeBinder(this)});
    }

    protected abstract void configure();

    protected Stage getStage() {
        Stage stage = Stage.PRODUCTION;
        try {
            Preferences userNode = Preferences.userNodeForPackage(PACKAGE);
            String userStage = userNode.get(STAGE_KEY, null);
            if (userStage != null) {
                stage = Stage.valueOf((String)userStage);
            } else {
                Preferences systemNode = Preferences.systemNodeForPackage(PACKAGE);
                String systemStage = systemNode.get(STAGE_KEY, null);
                if (systemStage != null) {
                    stage = Stage.valueOf((String)systemStage);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stage;
    }

    private static class DwrScopeBinder
    extends AbstractDwrModule {
        final AbstractDwrModule module;

        DwrScopeBinder(AbstractDwrModule module) {
            this.bindPotentiallyConflictingTypes = module.bindPotentiallyConflictingTypes;
            this.module = module;
        }

        protected void configure() {
            this.bindDwrScopes();
            this.install((Module)this.module);
        }
    }
}

