/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.util.AbstractSimpleContextScope;
import org.directwebremoting.guice.util.ContextScope;

public class DwrScopes {
    public static final ContextScope<HttpServletRequest> REQUEST = new AbstractSimpleContextScope<HttpServletRequest>(HttpServletRequest.class, "DwrScopes.REQUEST"){

        @Override
        public HttpServletRequest get() {
            return WebContextFactory.get().getHttpServletRequest();
        }

        @Override
        public Object get(HttpServletRequest request, String name) {
            return request.getAttribute(name);
        }

        @Override
        public void put(HttpServletRequest request, String name, Object value) {
            request.setAttribute(name, value);
        }
    };
    public static final ContextScope<ScriptSession> SCRIPT = new AbstractSimpleContextScope<ScriptSession>(ScriptSession.class, "DwrScopes.SCRIPT"){

        @Override
        public ScriptSession get() {
            return WebContextFactory.get().getScriptSession();
        }

        @Override
        public Object get(ScriptSession scriptSession, String name) {
            return scriptSession.getAttribute(name);
        }

        @Override
        public void put(ScriptSession scriptSession, String name, Object value) {
            scriptSession.setAttribute(name, value);
        }
    };
    public static final ContextScope<HttpSession> SESSION = new AbstractSimpleContextScope<HttpSession>(HttpSession.class, "DwrScopes.SESSION"){

        @Override
        public HttpSession get() {
            return WebContextFactory.get().getSession();
        }

        @Override
        public Object get(HttpSession session, String name) {
            return session.getAttribute(name);
        }

        @Override
        public void put(HttpSession session, String name, Object value) {
            session.setAttribute(name, value);
        }
    };
    public static final ContextScope<ServletContext> APPLICATION = new ApplicationScope("DwrScopes.APPLICATION");
    public static final ContextScope<ServletContext> GLOBAL = new ApplicationScope("DwrScopes.GLOBAL");

    private DwrScopes() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplicationScope
    extends AbstractSimpleContextScope<ServletContext> {
        ApplicationScope(String scopeName) {
            super(ServletContext.class, scopeName);
        }

        @Override
        public ServletContext get() {
            return DwrGuiceUtil.getServletContext();
        }

        @Override
        public Object get(ServletContext servletContext, String name) {
            return servletContext.getAttribute(name);
        }

        @Override
        public void put(ServletContext servletContext, String name, Object value) {
            servletContext.setAttribute(name, value);
        }
    }
}

