/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AccessDeniedException;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.impl.LoginRequiredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccessControl
implements AccessControl {
    protected boolean exposeInternals = false;
    protected Map<String, Policy> policyMap = new HashMap<String, Policy>();
    protected Map<String, Set<String>> roleRestrictMap = new HashMap<String, Set<String>>();
    protected static final String PACKAGE_DWR_DENY = "org.directwebremoting.";
    protected static final String PACKAGE_ALLOW_CREATE = "org.directwebremoting.export.";
    protected static final String PACKAGE_ALLOW_CONVERT = "org.directwebremoting.io.";

    @Override
    public void assertGeneralExecutionIsPossible(String scriptName, MethodDeclaration method) throws SecurityException {
        this.assertRoleRestriction(scriptName, method.getName());
        this.assertGeneralDisplayable(scriptName, method);
    }

    @Override
    public void assertMethodExecutionIsPossible(Class<?> clazz, Method method) throws SecurityException {
        this.assertMethodDisplayable(clazz, method);
    }

    @Override
    public void assertGeneralDisplayable(String scriptName, MethodDeclaration method) throws SecurityException {
        this.assertIsExecutable(scriptName, method.getName());
        if (!this.exposeInternals) {
            DefaultAccessControl.assertParametersNotDwrInternal(method);
        }
    }

    @Override
    public void assertMethodDisplayable(Class<?> clazz, Method method) throws SecurityException {
        DefaultAccessControl.assertIsMethodPublic(method);
        DefaultAccessControl.assertIsNotOnBaseObject(method);
        if (!this.exposeInternals) {
            DefaultAccessControl.assertClassNotDwrInternal(clazz);
        }
    }

    @Override
    public void addRoleRestriction(String scriptName, String methodName, String role) {
        String key = scriptName + '.' + methodName;
        Set<String> roles = this.roleRestrictMap.get(key);
        if (roles == null) {
            roles = new HashSet<String>();
            this.roleRestrictMap.put(key, roles);
        }
        roles.add(role);
    }

    @Override
    public void addIncludeRule(String scriptName, String methodName) {
        Policy policy = this.getPolicy(scriptName);
        if (policy.defaultAllow) {
            if (!policy.rules.isEmpty()) {
                throw new IllegalArgumentException("The module '" + scriptName + "' uses mixed include and exclude statements");
            }
            policy.defaultAllow = false;
        }
        policy.rules.add(methodName);
    }

    @Override
    public void addExcludeRule(String scriptName, String methodName) {
        Policy policy = this.getPolicy(scriptName);
        if (!policy.defaultAllow) {
            if (!policy.rules.isEmpty()) {
                throw new IllegalArgumentException("The module '" + scriptName + "' uses mixed include and exclude statements");
            }
            policy.defaultAllow = true;
        }
        policy.rules.add(methodName);
    }

    protected void assertRoleRestriction(String scriptName, String methodName) {
        Set<String> roles = this.getRoleRestrictions(scriptName, methodName);
        if (roles != null && !roles.isEmpty()) {
            HttpServletRequest req = WebContextFactory.get().getHttpServletRequest();
            DefaultAccessControl.assertAuthenticationIsValid(req);
            DefaultAccessControl.assertAllowedByRoles(req, roles);
        }
    }

    protected Set<String> getRoleRestrictions(String scriptName, String methodName) {
        String key = scriptName + '.' + methodName;
        return this.roleRestrictMap.get(key);
    }

    protected static void assertAuthenticationIsValid(HttpServletRequest req) throws SecurityException {
        req.getSession();
        if (!req.isRequestedSessionIdValid()) {
            throw new LoginRequiredException("Session timed out, or invalid");
        }
        if (req.getRemoteUser() == null) {
            throw new LoginRequiredException("No valid authentication details");
        }
    }

    protected static void assertAllowedByRoles(HttpServletRequest req, Set<String> roles) throws SecurityException {
        for (String role : roles) {
            if (!"*".equals(role) && !req.isUserInRole(role)) continue;
            return;
        }
        throw new AccessDeniedException("User is not in role for this method.");
    }

    protected static void assertIsMethodPublic(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new SecurityException("The method is not declared public");
        }
    }

    protected static void assertIsNotOnBaseObject(Method method) {
        if (method.getDeclaringClass() == Object.class) {
            throw new SecurityException("Methods defined in java.lang.Object are not accessible");
        }
    }

    protected void assertIsExecutable(String scriptName, String methodName) throws SecurityException {
        Policy policy = this.policyMap.get(scriptName);
        if (policy == null) {
            return;
        }
        String match = null;
        Iterator<String> it = policy.rules.iterator();
        while (it.hasNext() && match == null) {
            String test = it.next();
            if (!methodName.equals(test)) continue;
            match = test;
        }
        if (policy.defaultAllow && match != null) {
            throw new SecurityException("Method access is denied by rules in dwr.xml");
        }
        if (!policy.defaultAllow && match == null) {
            throw new SecurityException("Method access is denied by rules in dwr.xml");
        }
    }

    protected static void assertParametersNotDwrInternal(MethodDeclaration method) {
        for (int j = 0; j < method.getParameterTypes().length; ++j) {
            Class<?> paramType = method.getParameterTypes()[j];
            if (!paramType.getName().startsWith(PACKAGE_DWR_DENY) || paramType.getName().startsWith(PACKAGE_ALLOW_CONVERT)) continue;
            throw new SecurityException("Methods containing parameters defined by DWR can not be remoted");
        }
    }

    protected static void assertClassNotDwrInternal(Class<?> clazz) {
        String name = clazz.getName();
        if (name.startsWith(PACKAGE_DWR_DENY) && !name.startsWith(PACKAGE_ALLOW_CREATE)) {
            throw new SecurityException("Methods defined by DWR can not be remoted");
        }
    }

    protected Policy getPolicy(String type) {
        Policy policy = this.policyMap.get(type);
        if (policy == null) {
            policy = new Policy();
            this.policyMap.put(type, policy);
        }
        return policy;
    }

    public void setExposeInternals(boolean exposeInternals) {
        this.exposeInternals = exposeInternals;
    }

    static class Policy {
        boolean defaultAllow = true;
        List<String> rules = new ArrayList<String>();

        Policy() {
        }
    }
}

