/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.impl.ExportUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAjaxFilterManager
implements AjaxFilterManager {
    private List<AjaxFilter> global = new ArrayList<AjaxFilter>();
    private Map<String, List<AjaxFilter>> classBasedMap = new HashMap<String, List<AjaxFilter>>();

    @Override
    public List<AjaxFilter> getAjaxFilters(String scriptName) {
        if (ExportUtil.isSystemClass(scriptName)) {
            return Collections.emptyList();
        }
        ArrayList<AjaxFilter> reply = new ArrayList<AjaxFilter>();
        reply.addAll(this.global);
        List<AjaxFilter> classBased = this.classBasedMap.get(scriptName);
        if (classBased != null) {
            reply.addAll(classBased);
        }
        return Collections.unmodifiableList(reply);
    }

    @Override
    public void addAjaxFilter(AjaxFilter filter) {
        this.global.add(filter);
    }

    @Override
    public void addAjaxFilter(AjaxFilter filter, String scriptName) {
        List<AjaxFilter> classBased = this.classBasedMap.get(scriptName);
        if (classBased == null) {
            classBased = new ArrayList<AjaxFilter>();
            this.classBasedMap.put(scriptName, classBased);
        }
        classBased.add(filter);
    }
}

