/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.event.ScriptSessionBindingEvent;
import org.directwebremoting.event.ScriptSessionBindingListener;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.DefaultScriptSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptSession
implements RealScriptSession {
    protected final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile long lastAccessedTime = 0L;
    private volatile boolean invalidated = false;
    protected final SortedSet<ScriptConduit> conduits = Collections.synchronizedSortedSet(new TreeSet());
    protected final List<ScriptBuffer> scripts = Collections.synchronizedList(new ArrayList());
    protected final String id;
    protected final long creationTime;
    protected final String page;
    private String windowName;
    protected final DefaultScriptSessionManager manager;
    private static final Log log = LogFactory.getLog(DefaultScriptSession.class);

    protected DefaultScriptSession(String id, DefaultScriptSessionManager manager, String page) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.page = page;
        this.manager = manager;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    @Override
    public Object getAttribute(String name) {
        this.invalidateIfNeeded();
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.invalidateIfNeeded();
        if (value != null) {
            if (value instanceof ScriptSessionBindingListener) {
                ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                listener.valueBound(new ScriptSessionBindingEvent(this, name));
            }
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.invalidateIfNeeded();
        Object value = this.attributes.remove(name);
        if (value != null && value instanceof ScriptSessionBindingListener) {
            ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
            listener.valueUnbound(new ScriptSessionBindingEvent(this, name));
        }
    }

    @Override
    public Iterator<String> getAttributeNames() {
        this.invalidateIfNeeded();
        Set<String> keys = Collections.unmodifiableSet(new HashSet<String>(this.attributes.keySet()));
        return keys.iterator();
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof ScriptSessionBindingListener)) continue;
            ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
            listener.valueUnbound(new ScriptSessionBindingEvent(this, entry.getKey()));
        }
        this.manager.invalidate(this);
    }

    @Override
    public boolean isInvalidated() {
        return this.invalidated;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        this.invalidateIfNeeded();
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScript(ScriptBuffer script) {
        this.invalidateIfNeeded();
        if (script == null) {
            throw new NullPointerException("null script");
        }
        List<ScriptBuffer> list = this.scripts;
        synchronized (list) {
            if (this.conduits.isEmpty()) {
                boolean written = false;
                if (!written) {
                    this.scripts.add(script);
                }
            } else {
                ArrayList<ScriptConduit> conduitsList;
                boolean written = false;
                SortedSet<ScriptConduit> sortedSet = this.conduits;
                synchronized (sortedSet) {
                    conduitsList = new ArrayList<ScriptConduit>(this.conduits);
                }
                for (ScriptConduit conduit : conduitsList) {
                    try {
                        written = conduit.addScript(script);
                    }
                    catch (Exception ex) {
                        this.conduits.remove(conduit);
                        log.debug((Object)("Failed to write to ScriptConduit, removing conduit from list: " + conduit));
                    }
                    finally {
                        if (!written) continue;
                        break;
                    }
                }
                if (!written) {
                    this.scripts.add(script);
                }
            }
        }
    }

    @Override
    public boolean addScriptImmediately(ScriptBuffer script) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countPersistentConnections() {
        int persistentConnections = 0;
        SortedSet<ScriptConduit> sortedSet = this.conduits;
        synchronized (sortedSet) {
            for (ScriptConduit conduit : this.conduits) {
                if (!conduit.isHoldingConnectionToBrowser()) continue;
                ++persistentConnections;
            }
        }
        return persistentConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScriptConduit(ScriptConduit conduit) throws IOException {
        this.invalidateIfNeeded();
        List<ScriptBuffer> list = this.scripts;
        synchronized (list) {
            this.writeScripts(conduit);
            this.conduits.add(conduit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeScripts(ScriptConduit conduit) throws IOException {
        this.invalidateIfNeeded();
        List<ScriptBuffer> list = this.scripts;
        synchronized (list) {
            Iterator<ScriptBuffer> it = this.scripts.iterator();
            while (it.hasNext()) {
                ScriptBuffer script = it.next();
                try {
                    if (!conduit.addScript(script)) break;
                    it.remove();
                }
                catch (ConversionException ex) {
                    log.error((Object)("Failed to convert data. Dropping Javascript: " + script), (Throwable)ex);
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeScriptConduit(ScriptConduit conduit) {
        this.invalidateIfNeeded();
        List<ScriptBuffer> list = this.scripts;
        synchronized (list) {
            boolean removed = this.conduits.remove(conduit);
            if (!removed) {
                log.debug((Object)("removeScriptConduit called with ScriptConduit not in our list. conduit=" + conduit));
                this.debug();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWaitingScripts() {
        List<ScriptBuffer> list = this.scripts;
        synchronized (list) {
            return !this.scripts.isEmpty();
        }
    }

    @Override
    public String getPage() {
        return this.page;
    }

    @Override
    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    @Override
    public String getWindowName() {
        return this.windowName;
    }

    @Override
    public void updateLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    protected void invalidateIfNeeded() {
        if (this.invalidated) {
            return;
        }
        long now = System.currentTimeMillis();
        long age = now - this.lastAccessedTime;
        if (age > this.manager.getScriptSessionTimeout()) {
            this.invalidate();
        }
    }

    private void debug() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + this.conduits.size() + " ScriptConduits attached to " + this));
            for (ScriptConduit scriptConduit : this.conduits) {
                log.debug((Object)("- " + scriptConduit));
            }
        }
    }

    public int hashCode() {
        return 572 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultScriptSession that = (DefaultScriptSession)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "DefaultScriptSession[id=" + this.getDebugName() + "]";
    }

    protected String getDebugName() {
        int slashPos = this.id.indexOf(47);
        return this.id.substring(0, 4) + (slashPos >= 0 ? this.id.substring(slashPos, slashPos + 5) : "");
    }
}

