/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.event.ScriptSessionEvent;
import org.directwebremoting.event.ScriptSessionListener;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.UninitializingBean;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.Loggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptSessionManager
implements ScriptSessionManager,
InitializingBean,
UninitializingBean {
    private long scriptSessionTimeout = 300000L;
    protected PageNormalizer pageNormalizer;
    protected long scriptSessionCheckTime = 30000L;
    protected ScheduledThreadPoolExecutor executor;
    public static final String ATTRIBUTE_HTTPSESSIONID = "org.directwebremoting.ScriptSession.HttpSessionId";
    public static final String ATTRIBUTE_PAGE = "org.directwebremoting.ScriptSession.Page";
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected List<ScriptSessionListener> scriptSessionListeners = new CopyOnWriteArrayList<ScriptSessionListener>();
    private volatile ScheduledFuture<?> future;
    protected volatile long lastSessionCheckAt = System.currentTimeMillis();
    protected final Map<String, Set<String>> sessionXRef = new ConcurrentHashMap<String, Set<String>>();
    protected final ConcurrentMap<String, DefaultScriptSession> sessionMap = new ConcurrentHashMap<String, DefaultScriptSession>();
    protected final ConcurrentMap<String, Set<DefaultScriptSession>> pageSessionMap = new ConcurrentHashMap<String, Set<DefaultScriptSession>>();

    @Override
    public void afterContainerSetup(Container container) {
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultScriptSessionManager.this.maybeCheckTimeouts();
            }
        };
        this.future = this.executor.scheduleWithFixedDelay(runnable, 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void contextDestroyed() {
    }

    @Override
    public void servletDestroyed() {
        this.future.cancel(true);
    }

    @Override
    public RealScriptSession getScriptSession(String sentScriptId, String page, String httpSessionId) {
        DefaultScriptSession scriptSession;
        this.maybeCheckTimeouts();
        if ("".equals(sentScriptId)) {
            scriptSession = this.createScriptSession("", page);
            Loggers.SESSION.debug((Object)("Creating temporary script session on " + scriptSession.getPage()));
        } else {
            scriptSession = (DefaultScriptSession)this.sessionMap.get(sentScriptId);
            if (scriptSession == null) {
                scriptSession = this.createScriptSession(sentScriptId, page);
                Loggers.SESSION.debug((Object)("Creating " + scriptSession + " on " + scriptSession.getPage()));
                this.sessionMap.putIfAbsent(sentScriptId, scriptSession);
                this.fireScriptSessionCreatedEvent(scriptSession);
            } else {
                scriptSession.updateLastAccessedTime();
                String storedPage = scriptSession.getPage();
                if (!storedPage.equals(page)) {
                    Loggers.SESSION.error((Object)("Invalid Page: Passed page=" + page + ", but page in script session=" + storedPage));
                    throw new SecurityException("Invalid Page");
                }
            }
            this.associateScriptSessionAndPage(scriptSession, page);
            this.associateScriptSessionAndHttpSession(scriptSession, httpSessionId);
        }
        return scriptSession;
    }

    protected DefaultScriptSession createScriptSession(String sentScriptId, String page) {
        return new DefaultScriptSession(sentScriptId, this, page);
    }

    protected void associateScriptSessionAndHttpSession(DefaultScriptSession scriptSession, String httpSessionId) {
        if (httpSessionId == null) {
            return;
        }
        scriptSession.setAttribute(ATTRIBUTE_HTTPSESSIONID, httpSessionId);
        Set<String> scriptSessionIds = this.sessionXRef.get(httpSessionId);
        if (scriptSessionIds == null) {
            scriptSessionIds = new HashSet<String>();
            this.sessionXRef.put(httpSessionId, scriptSessionIds);
        }
        scriptSessionIds.add(scriptSession.getId());
    }

    protected void disassociateScriptSessionAndHttpSession(DefaultScriptSession scriptSession) {
        Object httpSessionId = scriptSession.getAttribute(ATTRIBUTE_HTTPSESSIONID);
        if (httpSessionId == null) {
            return;
        }
        Set<String> scriptSessionIds = this.sessionXRef.get(httpSessionId);
        if (scriptSessionIds == null) {
            Loggers.SESSION.debug((Object)"Warning: No script session ids for http session");
            return;
        }
        scriptSessionIds.remove(scriptSession.getId());
        if (scriptSessionIds.size() == 0) {
            this.sessionXRef.remove(httpSessionId);
        }
        scriptSession.setAttribute(ATTRIBUTE_HTTPSESSIONID, null);
    }

    protected void associateScriptSessionAndPage(DefaultScriptSession scriptSession, String page) {
        Set prev;
        if (page == null) {
            return;
        }
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Set<DefaultScriptSession> pageSessions = (HashSet<DefaultScriptSession>)this.pageSessionMap.get(normalizedPage);
        if (pageSessions == null && (prev = (Set)this.pageSessionMap.putIfAbsent(normalizedPage, pageSessions = new HashSet<DefaultScriptSession>())) != null) {
            pageSessions = prev;
        }
        pageSessions.add(scriptSession);
        scriptSession.setAttribute(ATTRIBUTE_PAGE, normalizedPage);
    }

    protected void disassociateScriptSessionAndPage(DefaultScriptSession scriptSession) {
        for (Set pageSessions : this.pageSessionMap.values()) {
            pageSessions.remove(scriptSession);
        }
    }

    @Override
    public Collection<RealScriptSession> getScriptSessionsByHttpSessionId(String httpSessionId) {
        ArrayList<RealScriptSession> reply = new ArrayList<RealScriptSession>();
        Set<String> scriptSessionIds = this.sessionXRef.get(httpSessionId);
        if (scriptSessionIds != null) {
            for (String scriptSessionId : scriptSessionIds) {
                DefaultScriptSession scriptSession = (DefaultScriptSession)this.sessionMap.get(scriptSessionId);
                if (scriptSession == null) continue;
                reply.add(scriptSession);
            }
        }
        return reply;
    }

    @Override
    public Collection<ScriptSession> getAllScriptSessions() {
        HashSet<ScriptSession> reply = new HashSet<ScriptSession>();
        reply.addAll(this.sessionMap.values());
        return reply;
    }

    protected void invalidate(DefaultScriptSession scriptSession) {
        Loggers.SESSION.debug((Object)("Invalidating " + scriptSession + " from " + scriptSession.getPage()));
        this.sessionMap.remove(scriptSession.getId());
        this.disassociateScriptSessionAndPage(scriptSession);
        this.disassociateScriptSessionAndHttpSession(scriptSession);
        this.fireScriptSessionDestroyedEvent(scriptSession);
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
            this.lastSessionCheckAt = now;
        }
    }

    protected void checkTimeouts() {
        long now = System.currentTimeMillis();
        ArrayList<DefaultScriptSession> timeouts = new ArrayList<DefaultScriptSession>();
        for (DefaultScriptSession defaultScriptSession : this.sessionMap.values()) {
            long age;
            if (defaultScriptSession.isInvalidated() || (age = now - defaultScriptSession.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
            timeouts.add(defaultScriptSession);
        }
        for (ScriptSession scriptSession : timeouts) {
            DefaultScriptSession session = (DefaultScriptSession)scriptSession;
            session.invalidate();
        }
    }

    @Override
    public void addScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.add(li);
    }

    @Override
    public void removeScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.remove(li);
    }

    protected void fireScriptSessionCreatedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = null;
        for (int i = this.scriptSessionListeners.size() - 1; i >= 0; --i) {
            if (ev == null) {
                ev = new ScriptSessionEvent(scriptSession);
            }
            this.scriptSessionListeners.get(i).sessionCreated(ev);
        }
    }

    protected void fireScriptSessionDestroyedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = null;
        for (int i = this.scriptSessionListeners.size() - 1; i >= 0; --i) {
            if (ev == null) {
                ev = new ScriptSessionEvent(scriptSession);
            }
            this.scriptSessionListeners.get(i).sessionDestroyed(ev);
        }
    }

    @Override
    public String getInitCode() {
        return "dwr.engine._execute(dwr.engine._pathToDwrServlet, '__System', 'pageLoaded', [ function() { dwr.engine._ordered = false; }]);";
    }

    @Override
    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long scriptSessionTimeout) {
        this.scriptSessionTimeout = scriptSessionTimeout;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }
}

