/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;

public class DwrServlet
extends HttpServlet {
    private Container container = null;
    protected WebContextFactory.WebContextBuilder webContextBuilder = null;
    private static final Log log = LogFactory.getLog(DwrServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            StartupUtil.logStartup(((Object)((Object)this)).getClass().getSimpleName(), servletConfig);
            this.container = this.createContainer(servletConfig);
            this.webContextBuilder = this.container.getBean(WebContextFactory.WebContextBuilder.class);
            this.configureContainer(this.container, servletConfig);
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.fatal((Object)"init failed", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (this.webContextBuilder != null) {
                this.webContextBuilder.disengageThread();
            }
        }
    }

    protected Container createContainer(ServletConfig servletConfig) throws ServletException {
        return StartupUtil.createAndSetupDefaultContainer(servletConfig);
    }

    protected void configureContainer(Container defaultContainer, ServletConfig servletConfig) throws ServletException, IOException {
        try {
            StartupUtil.configureContainerFully(defaultContainer, servletConfig);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webContextBuilder.engageThread(this.container, request, response);
            UrlProcessor processor = this.container.getBean(UrlProcessor.class);
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.disengageThread();
        }
    }

    public void destroy() {
        this.container.servletDestroyed();
        super.destroy();
    }

    public Container getContainer() {
        return this.container;
    }
}

