/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.Container;
import org.directwebremoting.extend.ContainerUtil;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.servlet.BaseInterfaceHandler;
import org.directwebremoting.servlet.DtoAllHandler;

public class InterfaceHandler
extends BaseInterfaceHandler {
    protected String interfaceHandlerUrl;
    protected Container container;
    protected DtoAllHandler dtoAllHandler;

    protected String getBaseInterfacePath() {
        return this.interfaceHandlerUrl;
    }

    public String generateInterfaceScript(String contextPath, String servletPath, String scriptName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(EnginePrivate.getRequireEngineScript()).append("\n");
        if (this.generateDtoClasses.matches(".*\\binterface\\b.*") && this.converterManager.getNamedConverterJavaScriptNames().size() > 0) {
            buffer.append(this.dtoAllHandler.generateDtoAllScript(contextPath, servletPath)).append("\n");
        }
        buffer.append("(function() {\n").append("  if (dwr.engine._getObject(\"" + scriptName + "\") == undefined) {\n").append("    var p;\n").append("    \n").append(this.remoter.generateInterfaceJavaScript(scriptName, "    ", "p", contextPath + servletPath)).append("    \n").append("    dwr.engine._setObject(\"" + scriptName + "\", p);\n").append("  }\n").append("})();\n");
        return buffer.toString();
    }

    public void setContainer(Container container) {
        this.dtoAllHandler = (DtoAllHandler)ContainerUtil.getHandlerForUrlProperty(container, "dtoAllHandlerUrl");
    }

    public void setInterfaceHandlerUrl(String interfaceHandlerUrl) {
        this.interfaceHandlerUrl = interfaceHandlerUrl;
    }
}

