/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Callback<T> {
    private final List<ScriptSession> sessions = new ArrayList<ScriptSession>();

    public Callback() {
        WebContext context = WebContextFactory.get();
        if (context == null) {
            throw new IllegalStateException("Attempt to use Callback without any ScriptSessions, from a non DWR thread. There is nowhere for replies to go.");
        }
        this.sessions.add(context.getScriptSession());
    }

    public Callback(ScriptSession session) {
        this.sessions.add(session);
    }

    public Callback(Collection<ScriptSession> sessionList) {
        this.sessions.addAll(sessionList);
    }

    public abstract void dataReturned(T var1);

    public Collection<ScriptSession> getScriptSessions() {
        return Collections.unmodifiableCollection(this.sessions);
    }
}

