/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.directwebremoting.util.Loggers;

public class DebuggingPrintWriter
extends PrintWriter {
    private String prefix;
    protected final StringBuffer buffer = new StringBuffer();

    public DebuggingPrintWriter(String prefix, Writer out) {
        super(out, false);
        this.prefix = prefix;
    }

    public DebuggingPrintWriter(String prefix, Writer out, boolean autoFlush) {
        super(out, autoFlush);
        this.prefix = prefix;
    }

    public DebuggingPrintWriter(String prefix, OutputStream out) {
        super(out, false);
        this.prefix = prefix;
    }

    public DebuggingPrintWriter(String prefix, OutputStream out, boolean autoFlush) {
        super((Writer)new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
        this.prefix = prefix;
    }

    public void print(boolean x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(char x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(int x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(long x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(float x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(double x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(char[] x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(String x) {
        super.print(x);
        this.buffer.append(x);
    }

    public void print(Object x) {
        super.print(x);
        this.buffer.append(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) {
        Object object = this.lock;
        synchronized (object) {
            this.printBuffer();
            super.println(x);
        }
    }

    private void printBuffer() {
        if (this.buffer.length() > 0) {
            Loggers.ACCESS.info((Object)(this.prefix + this.buffer.toString()));
            this.buffer.setLength(0);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

