/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.util.DelegatingServletOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeHttpServletResponse
implements HttpServletResponse {
    private static final String CHARSET_PREFIX = "charset=";
    private String characterEncoding = "ISO-8859-1";
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();
    private final DelegatingServletOutputStream outputStream = new DelegatingServletOutputStream(this.content);
    private PrintWriter writer = null;
    private int contentLength = 0;
    private String contentType = null;
    private int bufferSize = 4096;
    private boolean committed = false;
    private Locale locale = Locale.getDefault();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private int status = 200;
    private String errorMessage = null;
    private String redirectedUrl = null;
    private String forwardedUrl = null;
    private String includedUrl = null;

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new PrintWriter(targetWriter);
        }
        return this.writer;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void sendError(int newStatus, String newErrorMessage) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = newStatus;
        this.errorMessage = newErrorMessage;
        this.committed = true;
    }

    public void sendError(int newStatus) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = newStatus;
        this.committed = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void sendRedirect(String url) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        this.redirectedUrl = url;
        this.committed = true;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Deprecated
    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String contentType) {
        int charsetIndex;
        this.contentType = contentType;
        if (contentType != null && (charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX)) != -1) {
            String encoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
            this.setCharacterEncoding(encoding);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void addHeader(String name, String value) {
        this.doAddHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.doSetHeader(name, value);
    }

    public void addDateHeader(String name, long value) {
        this.doAddHeader(name, value);
    }

    public void setDateHeader(String name, long value) {
        this.doSetHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.doAddHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.doSetHeader(name, value);
    }

    private void doSetHeader(String name, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        this.headers.put(name, values);
    }

    private void doAddHeader(String name, Object value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    public List<Object> getHeaders(String name) {
        List<Object> value = this.headers.get(name);
        if (value instanceof List) {
            return value;
        }
        if (value != null) {
            return Collections.singletonList(value);
        }
        return Collections.EMPTY_LIST;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }

    public void disable() {
    }

    public void enable() {
    }

    public boolean isDisabled() {
        return false;
    }
}

