/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;

public class JavascriptUtil {
    private static final String[] RESERVED_ARRAY = new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "else", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "is", "namespace", "new", "null", "package", "private", "public", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "use", "var", "void", "while", "with", "abstract", "debugger", "enum", "goto", "implements", "interface", "native", "protected", "synchronized", "throws", "transient", "volatile", "boolean", "byte", "char", "double", "final", "float", "int", "long", "short", "static"};
    private static SortedSet<String> reserved = new TreeSet<String>();

    public static String escapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer writer = new StringBuffer(str.length() * 2);
        int sz = str.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                writer.append("\\u");
                writer.append(JavascriptUtil.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                writer.append("\\u0");
                writer.append(JavascriptUtil.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                writer.append("\\u00");
                writer.append(JavascriptUtil.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        writer.append('\\');
                        writer.append('b');
                        break;
                    }
                    case '\n': {
                        writer.append('\\');
                        writer.append('n');
                        break;
                    }
                    case '\t': {
                        writer.append('\\');
                        writer.append('t');
                        break;
                    }
                    case '\f': {
                        writer.append('\\');
                        writer.append('f');
                        break;
                    }
                    case '\r': {
                        writer.append('\\');
                        writer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            writer.append("\\u00");
                            writer.append(JavascriptUtil.hex(ch));
                            break;
                        }
                        writer.append("\\u000");
                        writer.append(JavascriptUtil.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    writer.append('\\');
                    writer.append('\'');
                    continue block12;
                }
                case '\"': {
                    writer.append('\\');
                    writer.append('\"');
                    continue block12;
                }
                case '\\': {
                    writer.append('\\');
                    writer.append('\\');
                    continue block12;
                }
                default: {
                    writer.append(ch);
                }
            }
        }
        return writer.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static String unescapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer writer = new StringBuffer(str.length());
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    writer.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode + " cause: " + nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        writer.append('\\');
                        break;
                    }
                    case '\'': {
                        writer.append('\'');
                        break;
                    }
                    case '\"': {
                        writer.append('\"');
                        break;
                    }
                    case 'r': {
                        writer.append('\r');
                        break;
                    }
                    case 'f': {
                        writer.append('\f');
                        break;
                    }
                    case 't': {
                        writer.append('\t');
                        break;
                    }
                    case 'n': {
                        writer.append('\n');
                        break;
                    }
                    case 'b': {
                        writer.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        writer.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            writer.append(ch);
        }
        if (hadSlash) {
            writer.append('\\');
        }
        return writer.toString();
    }

    public static boolean isReservedWord(String name) {
        return reserved.contains(name);
    }

    static {
        reserved.addAll(Arrays.asList(RESERVED_ARRAY));
    }
}

