/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnalyzerConfig {
    private static final Logger LOG = LogManager.getLogger(AnalyzerConfig.class);
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PARAM_VALUE_ENTRY = "value";
    private static final String PARAM_ELEMENT_NAME = "param";
    private Map<String, Analyzer> analyzers = new TreeMap<String, Analyzer>();
    private Analyzer defaultAnalyzer = null;

    public Analyzer getAnalyzerById(String id) {
        return this.analyzers.get(id);
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public void addAnalyzer(Element config) throws DatabaseConfigurationException {
        Analyzer analyzer = AnalyzerConfig.configureAnalyzer(config);
        if (analyzer == null) {
            return;
        }
        String id = config.getAttribute(ID_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)id)) {
            this.setDefaultAnalyzer(analyzer);
        } else {
            this.analyzers.put(id, analyzer);
        }
    }

    public void setDefaultAnalyzer(Analyzer analyzer) {
        this.defaultAnalyzer = analyzer;
    }

    protected static Analyzer configureAnalyzer(Element config) throws DatabaseConfigurationException {
        String className = config.getAttribute(CLASS_ATTRIBUTE);
        Analyzer newAnalyzer = null;
        if (StringUtils.isBlank((CharSequence)className)) {
            LOG.error("Missing class attribute or attribute is empty.");
        } else {
            List<KeyTypedValue> cParams;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOG.error(String.format("Lucene index: analyzer class %s not found. (%s)", className, e.getMessage()));
                return null;
            }
            if (!Analyzer.class.isAssignableFrom(clazz)) {
                LOG.error(String.format("Lucene index: analyzer class has to be a subclass of %s", Analyzer.class.getName()));
                return null;
            }
            try {
                cParams = AnalyzerConfig.getAllConstructorParameters(config);
            }
            catch (ParameterException pe) {
                LOG.error(String.format("Unable to get parameters for %s: %s", className, pe.getMessage()), (Throwable)pe);
                cParams = new ArrayList<KeyTypedValue>();
            }
            Class[] cParamClasses = new Class[cParams.size()];
            Object[] cParamValues = new Object[cParams.size()];
            for (int i = 0; i < cParams.size(); ++i) {
                KeyTypedValue ktv = cParams.get(i);
                cParamClasses[i] = ktv.getValueClass();
                cParamValues[i] = ktv.getValue();
            }
            if (cParamClasses.length > 0 && cParamClasses[0] == Version.class) {
                if (LOG.isDebugEnabled()) {
                    Version version = (Version)cParamValues[0];
                    LOG.debug(String.format("An explicit Version %s of lucene has been specified.", version.toString()));
                }
                newAnalyzer = AnalyzerConfig.createInstance(clazz, cParamClasses, cParamValues);
            } else {
                Object[] vcParamValues;
                Class<?>[] vcParamClasses = AnalyzerConfig.addVersionToClasses(cParamClasses);
                newAnalyzer = AnalyzerConfig.createInstance(clazz, vcParamClasses, vcParamValues = AnalyzerConfig.addVersionValueToValues(cParamValues));
                if (newAnalyzer == null) {
                    newAnalyzer = AnalyzerConfig.createInstance(clazz, cParamClasses, cParamValues);
                }
            }
        }
        if (newAnalyzer == null) {
            LOG.error(String.format("Unable to create analyzer '%s'", className));
        }
        return newAnalyzer;
    }

    private static Analyzer createInstance(Class<?> clazz, Class<?>[] vcParamClasses, Object[] vcParamValues) {
        String className = clazz.getName();
        try {
            Constructor<?> cstr = clazz.getDeclaredConstructor(vcParamClasses);
            cstr.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Using analyzer %s", className));
            }
            return (Analyzer)cstr.newInstance(vcParamValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            LOG.error(String.format("Exception while instantiating analyzer class %s: %s", className, e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException ex) {
            LOG.error(String.format("Could not find matching analyzer class constructor%s: %s", className, ex.getMessage()), (Throwable)ex);
        }
        return null;
    }

    private static Object[] addVersionValueToValues(Object[] cParamValues) {
        Object[] vcParamValues = new Object[cParamValues.length + 1];
        vcParamValues[0] = LuceneIndex.LUCENE_VERSION_IN_USE;
        System.arraycopy(cParamValues, 0, vcParamValues, 1, cParamValues.length);
        return vcParamValues;
    }

    private static Class<?>[] addVersionToClasses(Class<?>[] cParamClasses) {
        Class[] vcParamClasses = new Class[cParamClasses.length + 1];
        vcParamClasses[0] = Version.class;
        System.arraycopy(cParamClasses, 0, vcParamClasses, 1, cParamClasses.length);
        return vcParamClasses;
    }

    private static List<KeyTypedValue> getAllConstructorParameters(Element config) throws ParameterException {
        ArrayList<KeyTypedValue> parameters = new ArrayList<KeyTypedValue>();
        NodeList params = config.getElementsByTagNameNS("http://exist-db.org/collection-config/1.0", PARAM_ELEMENT_NAME);
        for (int i = 0; i < params.getLength(); ++i) {
            parameters.add(AnalyzerConfig.getConstructorParameter((Element)params.item(i)));
        }
        return parameters;
    }

    private static KeyTypedValue getConstructorParameter(Element param) throws ParameterException {
        NamedNodeMap attrs = param.getAttributes();
        Node namedItem = attrs.getNamedItem(NAME_ATTRIBUTE);
        String name = namedItem == null ? null : namedItem.getNodeValue();
        namedItem = attrs.getNamedItem(TYPE_ATTRIBUTE);
        String type = namedItem == null ? null : namedItem.getNodeValue();
        namedItem = attrs.getNamedItem(PARAM_VALUE_ENTRY);
        String value = namedItem == null ? null : namedItem.getNodeValue();
        KeyTypedValue parameter = null;
        if (StringUtils.isBlank((CharSequence)type) || "java.lang.String".equals(type)) {
            if (value == null) {
                throw new ParameterException("The 'value' attribute must exist and must contain String value.");
            }
            parameter = new KeyTypedValue(name, value);
        } else {
            switch (type) {
                case "java.lang.reflect.Field": {
                    if (value == null) {
                        throw new ParameterException("The 'value' attribute must exist and must contain a full classname.");
                    }
                    String clazzName = value.substring(0, value.lastIndexOf(46));
                    String fieldName = value.substring(value.lastIndexOf(46) + 1);
                    try {
                        Class<?> fieldClazz = Class.forName(clazzName);
                        Field field = fieldClazz.getField(fieldName);
                        field.setAccessible(true);
                        Object fValue = field.get(fieldClazz.newInstance());
                        parameter = new KeyTypedValue(name, fValue);
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException nsfe) {
                        throw new ParameterException(nsfe.getMessage(), nsfe);
                    }
                }
                case "java.io.File": {
                    if (value == null) {
                        throw new ParameterException("The 'value' attribute must exist and must contain a file name.");
                    }
                    LOG.info(String.format("Type '%s' has been deprecated in recent Lucene versions, please use 'java.io.FileReader' (short 'file') instead.", type));
                    parameter = new KeyTypedValue(name, new File(value), File.class);
                    break;
                }
                case "java.io.FileReader": 
                case "file": {
                    if (value == null) {
                        throw new ParameterException("The 'value' attribute must exist and must contain a file name.");
                    }
                    try {
                        FileReader fileReader = new FileReader(value);
                        parameter = new KeyTypedValue(name, fileReader, Reader.class);
                    }
                    catch (FileNotFoundException ex) {
                        LOG.error(String.format("File '%s' could not be found.", value), (Throwable)ex);
                    }
                    break;
                }
                case "java.util.Set": {
                    LOG.info(String.format("Type '%s' has been deprecated in recent Lucene versions, please use 'org.apache.lucene.analysis.util.CharArraySet' (short 'set') instead.", type));
                    Set<String> s = AnalyzerConfig.getConstructorParameterSetValues(param);
                    parameter = new KeyTypedValue(name, s, Set.class);
                    break;
                }
                case "org.apache.lucene.analysis.util.CharArraySet": 
                case "set": {
                    CharArraySet s = AnalyzerConfig.getConstructorParameterCharArraySetValues(param);
                    parameter = new KeyTypedValue(name, s, CharArraySet.class);
                    break;
                }
                case "java.lang.Integer": 
                case "int": {
                    if (value == null) {
                        throw new ParameterException("The 'value' attribute must exist and must contain an integer value.");
                    }
                    try {
                        Integer n = Integer.parseInt(value);
                        parameter = new KeyTypedValue(name, n);
                    }
                    catch (NumberFormatException ex) {
                        LOG.error(String.format("Value %s could not be converted to an integer. %s", value, ex.getMessage()));
                    }
                    break;
                }
                case "java.lang.Boolean": 
                case "boolean": {
                    if (value == null) {
                        throw new ParameterException("The 'value' attribute must exist and must contain a boolean value.");
                    }
                    boolean b = Boolean.parseBoolean(value);
                    parameter = new KeyTypedValue(name, b);
                    break;
                }
                default: {
                    if (value == null) {
                        throw new ParameterException("The 'value' attribute must exist and must contain a value.");
                    }
                    try {
                        Class<?> clazz = Class.forName(type);
                        if (clazz.isEnum()) {
                            parameter = new KeyTypedValue(name, Enum.valueOf(clazz, value), clazz);
                            break;
                        }
                        parameter = new KeyTypedValue(name, value);
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new ParameterException(String.format("Class for type: %s not found. %s", type, cnfe.getMessage()), cnfe);
                    }
                }
            }
        }
        return parameter;
    }

    private static Set<String> getConstructorParameterSetValues(Element param) {
        HashSet<String> set = new HashSet<String>();
        NodeList values = param.getElementsByTagNameNS("http://exist-db.org/collection-config/1.0", PARAM_VALUE_ENTRY);
        for (int i = 0; i < values.getLength(); ++i) {
            Element value = (Element)values.item(i);
            set.add(value.getTextContent());
        }
        return set;
    }

    private static CharArraySet getConstructorParameterCharArraySetValues(Element param) {
        Set<String> set = AnalyzerConfig.getConstructorParameterSetValues(param);
        return CharArraySet.copy((Version)LuceneIndex.LUCENE_VERSION_IN_USE, set);
    }

    private static class ParameterException
    extends Exception {
        private static final long serialVersionUID = -4823392401966008877L;

        public ParameterException(String message) {
            super(message);
        }

        public ParameterException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class KeyTypedValue {
        private final String key;
        private final Object value;
        private final Class<?> valueClass;

        public KeyTypedValue(String key, Object value) {
            this(key, value, value.getClass());
        }

        public KeyTypedValue(String key, Object value, Class<?> valueClass) {
            this.key = key;
            this.value = value;
            this.valueClass = valueClass;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getValueClass() {
            return this.valueClass;
        }
    }
}

