/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import org.exist.dom.QName;
import org.exist.indexing.lucene.AbstractTextExtractor;
import org.exist.util.XMLString;

public class DefaultTextExtractor
extends AbstractTextExtractor {
    private int stack = 0;
    private boolean addSpaceBeforeNext = false;

    @Override
    public int startElement(QName name) {
        if (this.isInlineNode(name)) {
            this.addSpaceBeforeNext = false;
        }
        if (this.config.isIgnoredNode(name) || this.idxConfig != null && this.idxConfig.isIgnoredNode(name)) {
            ++this.stack;
        } else if (!this.isInlineNode(name) && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) != ' ') {
            this.buffer.append(' ');
            return 1;
        }
        return 0;
    }

    private boolean isInlineNode(QName name) {
        return this.config.isInlineNode(name) || this.idxConfig != null && this.idxConfig.isInlineNode(name);
    }

    @Override
    public int endElement(QName name) {
        if (this.config.isIgnoredNode(name) || this.idxConfig != null && this.idxConfig.isIgnoredNode(name)) {
            --this.stack;
        } else if (!this.isInlineNode(name)) {
            this.addSpaceBeforeNext = true;
        }
        return 0;
    }

    @Override
    public int beforeCharacters() {
        if (this.addSpaceBeforeNext && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) != ' ') {
            this.buffer.append(' ');
            this.addSpaceBeforeNext = false;
            return 1;
        }
        return 0;
    }

    @Override
    public int characters(XMLString text) {
        if (this.stack == 0) {
            this.buffer.append(text);
            return text.length();
        }
        return 0;
    }
}

