/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.exist.indexing.lucene.AnalyzerConfig;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;

public class FieldType {
    private static final String ID_ATTR = "id";
    private static final String ANALYZER_ID_ATTR = "analyzer";
    private static final String BOOST_ATTRIB = "boost";
    private static final String STORE_ATTRIB = "store";
    private String id = null;
    private String analyzerId = null;
    private Analyzer analyzer = null;
    private float boost = -1.0f;
    private Field.Store store = null;

    public FieldType(Element config, AnalyzerConfig analyzers) throws DatabaseConfigurationException {
        String storeAttr;
        String aId;
        if ("fieldType".equals(config.getLocalName())) {
            this.id = config.getAttribute(ID_ATTR);
            if (StringUtils.isEmpty((CharSequence)this.id)) {
                throw new DatabaseConfigurationException("fieldType needs an attribute 'id'");
            }
        }
        if ((aId = config.getAttribute(ANALYZER_ID_ATTR)) != null && aId.length() > 0) {
            this.analyzer = analyzers.getAnalyzerById(aId);
            if (this.analyzer == null) {
                throw new DatabaseConfigurationException("No analyzer configured for id " + aId);
            }
            this.analyzerId = aId;
        } else {
            this.analyzer = analyzers.getDefaultAnalyzer();
        }
        String boostAttr = config.getAttribute(BOOST_ATTRIB);
        if (boostAttr != null && boostAttr.length() > 0) {
            try {
                this.boost = Float.parseFloat(boostAttr);
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("Invalid value for attribute 'boost'. Expected float, got: " + boostAttr);
            }
        }
        if ((storeAttr = config.getAttribute(STORE_ATTRIB)) != null && storeAttr.length() > 0) {
            this.store = storeAttr.equalsIgnoreCase("yes") ? Field.Store.YES : Field.Store.NO;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getAnalyzerId() {
        return this.analyzerId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public float getBoost() {
        return this.boost;
    }

    public Field.Store getStore() {
        return this.store;
    }
}

