/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.indexing.lucene.AnalyzerConfig;
import org.exist.indexing.lucene.FieldType;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LuceneIndexConfig {
    private static final String N_INLINE = "inline";
    private static final String N_IGNORE = "ignore";
    private static final String IGNORE_ELEMENT = "ignore";
    private static final String INLINE_ELEMENT = "inline";
    private static final String MATCH_ATTR_ELEMENT = "match-attribute";
    private static final String HAS_ATTR_ELEMENT = "has-attribute";
    private static final String MATCH_SIBLING_ATTR_ELEMENT = "match-sibling-attribute";
    private static final String HAS_SIBLING_ATTR_ELEMENT = "has-sibling-attribute";
    public static final String QNAME_ATTR = "qname";
    public static final String MATCH_ATTR = "match";
    public static final String FIELD_ATTR = "field";
    public static final String TYPE_ATTR = "type";
    private String name = null;
    private NodePath path = null;
    private boolean isQNameIndex = false;
    private Map<QName, String> specialNodes = null;
    private LuceneIndexConfig nextConfig = null;
    private FieldType type = null;
    private MultiMap matchAttrs;
    protected static final Logger LOG = LogManager.getLogger(LuceneIndexConfig.class);

    public LuceneIndexConfig(Element config, Map<String, String> namespaces, AnalyzerConfig analyzers, Map<String, FieldType> fieldTypes) throws DatabaseConfigurationException {
        String fieldType;
        if (config.hasAttribute(QNAME_ATTR)) {
            QName qname = LuceneIndexConfig.parseQName(config, namespaces);
            this.path = new NodePath(qname);
            this.isQNameIndex = true;
        } else {
            String matchPath = config.getAttribute(MATCH_ATTR);
            try {
                this.path = new NodePath(namespaces, matchPath);
                if (this.path.length() == 0) {
                    throw new DatabaseConfigurationException("Lucene module: Invalid match path in collection config: " + matchPath);
                }
            }
            catch (IllegalArgumentException e) {
                throw new DatabaseConfigurationException("Lucene module: invalid qname in configuration: " + e.getMessage());
            }
        }
        String name = config.getAttribute(FIELD_ATTR);
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        if ((fieldType = config.getAttribute(TYPE_ATTR)) != null && fieldType.length() > 0) {
            this.type = fieldTypes.get(fieldType);
        }
        if (this.type == null) {
            this.type = new FieldType(config, analyzers);
        }
        this.parse(config, namespaces);
    }

    private void parse(Element root, Map<String, String> namespaces) throws DatabaseConfigurationException {
        block15: for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            String localName;
            if (child.getNodeType() != 1 || null == (localName = child.getLocalName())) continue;
            Element configElement = (Element)child;
            switch (localName) {
                case "ignore": {
                    String qnameAttr = configElement.getAttribute(QNAME_ATTR);
                    if (StringUtils.isEmpty((CharSequence)qnameAttr)) {
                        throw new DatabaseConfigurationException("Lucene configuration element 'ignore' needs an attribute 'qname'");
                    }
                    if (this.specialNodes == null) {
                        this.specialNodes = new TreeMap<QName, String>();
                    }
                    this.specialNodes.put(LuceneIndexConfig.parseQName(qnameAttr, namespaces), "ignore");
                    continue block15;
                }
                case "inline": {
                    String qnameAttr = configElement.getAttribute(QNAME_ATTR);
                    if (StringUtils.isEmpty((CharSequence)qnameAttr)) {
                        throw new DatabaseConfigurationException("Lucene configuration element 'inline' needs an attribute 'qname'");
                    }
                    if (this.specialNodes == null) {
                        this.specialNodes = new TreeMap<QName, String>();
                    }
                    this.specialNodes.put(LuceneIndexConfig.parseQName(qnameAttr, namespaces), "inline");
                    continue block15;
                }
                case "match-sibling-attribute": 
                case "has-sibling-attribute": 
                case "has-attribute": 
                case "match-attribute": {
                    float boost;
                    boolean onSibling;
                    boolean doMatch = localName.equals(MATCH_ATTR_ELEMENT) || localName.equals(MATCH_SIBLING_ATTR_ELEMENT);
                    boolean bl = onSibling = localName.equals(HAS_SIBLING_ATTR_ELEMENT) || localName.equals(MATCH_SIBLING_ATTR_ELEMENT);
                    if (onSibling && !this.isAttributeNode()) {
                        throw new DatabaseConfigurationException("Lucene module: " + localName + " can only be used on attribute");
                    }
                    if (!onSibling && this.isAttributeNode()) {
                        throw new DatabaseConfigurationException("Lucene module: " + localName + " can not be used on attribute");
                    }
                    String qname = configElement.getAttribute(QNAME_ATTR);
                    if (StringUtils.isEmpty((CharSequence)qname)) {
                        throw new DatabaseConfigurationException("Lucene configuration element '" + localName + " needs an attribute 'qname'");
                    }
                    String boostStr = configElement.getAttribute("boost");
                    try {
                        boost = Float.parseFloat(boostStr);
                    }
                    catch (NumberFormatException e) {
                        throw new DatabaseConfigurationException("Invalid value for attribute 'boost'. Expected float, got: " + boostStr);
                    }
                    String value = null;
                    if (doMatch && StringUtils.isEmpty((CharSequence)(value = configElement.getAttribute("value")))) {
                        throw new DatabaseConfigurationException("Lucene configuration element '" + localName + " needs an attribute 'value'");
                    }
                    if (this.matchAttrs == null) {
                        this.matchAttrs = new MultiValueMap();
                    }
                    this.matchAttrs.put((Object)qname, (Object)new MatchAttrData(qname, value, boost, onSibling));
                    continue block15;
                }
            }
        }
    }

    public Analyzer getAnalyzer() {
        return this.type.getAnalyzer();
    }

    public String getAnalyzerId() {
        return this.type.getAnalyzerId();
    }

    public QName getQName() {
        return this.path.getLastComponent();
    }

    public NodePath getNodePath() {
        return this.path;
    }

    public float getBoost() {
        return this.type.getBoost();
    }

    public float getAttrBoost(Collection<AttrImpl> attributes) {
        float boost = 0.0f;
        boolean hasBoost = false;
        for (Attr attr : attributes) {
            Collection matchAttrData = (Collection)this.matchAttrs.get((Object)attr.getName());
            if (matchAttrData == null) continue;
            for (MatchAttrData matchAttrDatum : matchAttrData) {
                if (matchAttrDatum.value != null && !matchAttrDatum.value.equals(attr.getValue())) continue;
                hasBoost = true;
                boost += matchAttrDatum.boost;
            }
        }
        if (hasBoost) {
            return boost;
        }
        return this.getBoost();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void add(LuceneIndexConfig config) {
        if (this.nextConfig == null) {
            this.nextConfig = config;
        } else {
            this.nextConfig.add(config);
        }
    }

    public LuceneIndexConfig getNext() {
        return this.nextConfig;
    }

    private boolean isAttributeNode() {
        return this.path.getLastComponent().getNameType() == 1;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public boolean isIgnoredNode(QName qname) {
        return this.specialNodes != null && this.specialNodes.get(qname) == "ignore";
    }

    public boolean isInlineNode(QName qname) {
        return this.specialNodes != null && this.specialNodes.get(qname) == "inline";
    }

    public static QName parseQName(Element config, Map<String, String> namespaces) throws DatabaseConfigurationException {
        String name = config.getAttribute(QNAME_ATTR);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new DatabaseConfigurationException("Lucene index configuration error: element " + config.getNodeName() + " must have an attribute " + QNAME_ATTR);
        }
        return LuceneIndexConfig.parseQName(name, namespaces);
    }

    protected static QName parseQName(String name, Map<String, String> namespaces) throws DatabaseConfigurationException {
        boolean isAttribute = false;
        if (name.startsWith("@")) {
            isAttribute = true;
            name = name.substring(1);
        }
        try {
            String prefix = QName.extractPrefix((String)name);
            String localName = QName.extractLocalName((String)name);
            String namespaceURI = "";
            if (prefix != null && (namespaceURI = namespaces.get(prefix)) == null) {
                throw new DatabaseConfigurationException("No namespace defined for prefix: " + prefix + " in index definition");
            }
            QName qname = isAttribute ? new QName(localName, namespaceURI, prefix, 1) : new QName(localName, namespaceURI, prefix);
            return qname;
        }
        catch (QName.IllegalQNameException e) {
            throw new DatabaseConfigurationException("Lucene index configuration error: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean match(NodePath other) {
        if (this.isQNameIndex) {
            QName qn1 = this.path.getLastComponent();
            QName qn2 = other.getLastComponent();
            return qn1.getNameType() == qn2.getNameType() && qn2.equals((Object)qn1);
        }
        return this.path.match(other);
    }

    public String toString() {
        return this.path.toString();
    }

    boolean shouldReindexOnAttributeChange() {
        return this.matchAttrs != null;
    }

    private static class MatchAttrData {
        final String qname;
        final String value;
        final float boost;
        final boolean onSibling;

        MatchAttrData(String qname, String value, float boost, boolean onSibling) {
            this.qname = qname;
            this.value = value;
            this.boost = boost;
            this.onSibling = onSibling;
        }
    }
}

