/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.indexing.QNamedKeysIndex;
import org.exist.indexing.StreamListener;
import org.exist.indexing.lucene.BinaryTokenStream;
import org.exist.indexing.lucene.ClassicQueryParserWrapper;
import org.exist.indexing.lucene.DefaultTextExtractor;
import org.exist.indexing.lucene.FieldType;
import org.exist.indexing.lucene.LuceneConfig;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexConfig;
import org.exist.indexing.lucene.LuceneMatchListener;
import org.exist.indexing.lucene.LuceneUtil;
import org.exist.indexing.lucene.PlainTextHighlighter;
import org.exist.indexing.lucene.PlainTextIndexConfig;
import org.exist.indexing.lucene.QueryParserWrapper;
import org.exist.indexing.lucene.TextExtractor;
import org.exist.indexing.lucene.XMLToQuery;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.MetaStreamListener;
import org.exist.storage.NodePath;
import org.exist.storage.btree.DBException;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.pool.NodePool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneIndexWorker
implements OrderedValuesIndex,
QNamedKeysIndex {
    public static final String OPTION_DEFAULT_OPERATOR = "default-operator";
    public static final String OPTION_PHRASE_SLOP = "phrase-slop";
    public static final String OPTION_LEADING_WILDCARD = "leading-wildcard";
    public static final String OPTION_FILTER_REWRITE = "filter-rewrite";
    public static final String DEFAULT_OPERATOR_OR = "or";
    public static final String OPTION_LOWERCASE_EXPANDED_TERMS = "lowercase-expanded-terms";
    public static final org.apache.lucene.document.FieldType TYPE_NODE_ID = new org.apache.lucene.document.FieldType();
    static final Logger LOG;
    protected LuceneIndex index;
    private LuceneMatchListener matchListener = null;
    private XMLToQuery queryTranslator;
    private DBBroker broker;
    private DocumentImpl currentDoc = null;
    private StreamListener.ReindexMode mode = StreamListener.ReindexMode.STORE;
    private LuceneConfig config;
    private Stack<TextExtractor> contentStack = null;
    private Set<NodeId> nodesToRemove = null;
    private List<PendingDoc> nodesToWrite = null;
    private Document pendingDoc = null;
    private int cachedNodesSize = 0;
    private int maxCachedNodesSize = 0x400000;
    private Analyzer analyzer;
    public static final String FIELD_DOC_ID = "docId";
    public static final String FIELD_DOC_URI = "docUri";
    private boolean isReindexing;
    private StreamListener listener = new LuceneStreamListener();

    public LuceneIndexWorker(LuceneIndex parent, DBBroker broker) {
        this.index = parent;
        this.broker = broker;
        this.queryTranslator = new XMLToQuery(this.index);
    }

    public String getIndexId() {
        return LuceneIndex.ID;
    }

    public String getIndexName() {
        return this.index.getIndexName();
    }

    public QueryRewriter getQueryRewriter(XQueryContext context) {
        return null;
    }

    public Object configure(IndexController controller, NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        LOG.debug("Configuring lucene index...");
        this.config = new LuceneConfig(configNodes, namespaces);
        return this.config;
    }

    public void flush() {
        switch (this.mode) {
            case STORE: {
                this.write();
                break;
            }
            case REMOVE_ALL_NODES: {
                this.removeDocument(this.currentDoc.getDocId());
                break;
            }
            case REMOVE_SOME_NODES: {
                this.removeNodes();
                break;
            }
            case REMOVE_BINARY: {
                this.removePlainTextIndexes();
            }
        }
    }

    public void setDocument(DocumentImpl document) {
        this.setDocument(document, StreamListener.ReindexMode.UNKNOWN);
    }

    public void setDocument(DocumentImpl document, StreamListener.ReindexMode newMode) {
        this.currentDoc = document;
        this.contentStack = null;
        IndexSpec indexConf = document.getCollection().getIndexConfiguration(this.broker);
        if (indexConf != null) {
            this.config = (LuceneConfig)indexConf.getCustomIndexSpec(LuceneIndex.ID);
            if (this.config != null) {
                this.config = new LuceneConfig(this.config);
            }
        }
        this.mode = newMode;
    }

    public void setMode(StreamListener.ReindexMode mode) {
        this.mode = mode;
        switch (mode) {
            case STORE: {
                if (this.nodesToWrite == null) {
                    this.nodesToWrite = new ArrayList<PendingDoc>();
                } else {
                    this.nodesToWrite.clear();
                }
                this.cachedNodesSize = 0;
                break;
            }
            case REMOVE_SOME_NODES: {
                this.nodesToRemove = new TreeSet<NodeId>();
            }
        }
    }

    public DocumentImpl getDocument() {
        return this.currentDoc;
    }

    public StreamListener.ReindexMode getMode() {
        return this.mode;
    }

    public <T extends IStoredNode> IStoredNode getReindexRoot(IStoredNode<T> node, NodePath path, boolean insert, boolean includeSelf) {
        if (this.config == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            IStoredNode parentStoredNode = node.getParentStoredNode();
            Iterator<LuceneIndexConfig> configIt = this.config.getConfig(parentStoredNode.getPath());
            while (configIt.hasNext()) {
                LuceneIndexConfig idxConfig = configIt.next();
                if (!idxConfig.shouldReindexOnAttributeChange() || !idxConfig.match(path)) continue;
                return parentStoredNode;
            }
            NamedNodeMap attributes = parentStoredNode.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                IStoredNode attr = (IStoredNode)attributes.item(i);
                if (attr.getPrefix() != null && "xmlns".equals(attr.getPrefix())) continue;
                configIt = this.config.getConfig(attr.getPath());
                while (configIt.hasNext()) {
                    LuceneIndexConfig idxConfig = configIt.next();
                    if (!idxConfig.shouldReindexOnAttributeChange() || !idxConfig.match(path)) continue;
                    return parentStoredNode;
                }
            }
            return null;
        }
        NodePath p = new NodePath(path);
        boolean reindexRequired = false;
        if (node.getNodeType() == 1 && !includeSelf) {
            p.removeLastComponent();
        }
        for (int i = 0; i < p.length(); ++i) {
            if (this.config.matches(p)) {
                reindexRequired = true;
                break;
            }
            p.removeLastComponent();
        }
        if (reindexRequired) {
            p = new NodePath(path);
            IStoredNode topMost = null;
            IStoredNode currentNode = node;
            if (currentNode.getNodeType() != 1) {
                currentNode = currentNode.getParentStoredNode();
            }
            while (currentNode != null) {
                if (this.config.matches(p)) {
                    topMost = currentNode;
                }
                currentNode = currentNode.getParentStoredNode();
                p.removeLastComponent();
            }
            return topMost;
        }
        return null;
    }

    public StreamListener getListener() {
        return this.listener;
    }

    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        boolean needToFilter = false;
        for (Match nextMatch = proxy.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (nextMatch.getIndexId() != LuceneIndex.ID) continue;
            needToFilter = true;
            break;
        }
        if (!needToFilter) {
            return null;
        }
        if (this.matchListener == null) {
            this.matchListener = new LuceneMatchListener(this.index, broker, proxy);
        } else {
            this.matchListener.reset(broker, proxy);
        }
        return this.matchListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocument(int docId) {
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            BytesRefBuilder bytes = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)docId, (int)0, (BytesRefBuilder)bytes);
            Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
            writer.deleteDocuments(new Term[]{dt});
        }
        catch (IOException e) {
            LOG.warn("Error while removing lucene index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.mode = StreamListener.ReindexMode.STORE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePlainTextIndexes() {
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            String uri = this.currentDoc.getURI().toString();
            Term dt = new Term(FIELD_DOC_URI, uri);
            writer.deleteDocuments(new Term[]{dt});
        }
        catch (IOException e) {
            LOG.warn("Error while removing lucene index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.mode = StreamListener.ReindexMode.STORE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(Collection collection, DBBroker broker, boolean reindex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing collection " + collection.getURI());
        }
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                BytesRefBuilder bytes = new BytesRefBuilder();
                NumericUtils.intToPrefixCoded((int)doc.getDocId(), (int)0, (BytesRefBuilder)bytes);
                Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
                writer.deleteDocuments(new Term[]{dt});
            }
        }
        catch (IOException | PermissionDeniedException | LockException e) {
            LOG.error("Error while removing lucene index: " + e.getMessage(), e);
        }
        finally {
            this.index.releaseWriter(writer);
            if (reindex) {
                try {
                    this.index.sync();
                }
                catch (DBException e) {
                    LOG.warn("Exception during reindex: " + e.getMessage(), (Throwable)e);
                }
            }
            this.mode = StreamListener.ReindexMode.STORE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collection removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNodes() {
        if (this.nodesToRemove == null) {
            return;
        }
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            BytesRefBuilder bytes = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)this.currentDoc.getDocId(), (int)0, (BytesRefBuilder)bytes);
            Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
            TermQuery tq = new TermQuery(dt);
            for (NodeId nodeId : this.nodesToRemove) {
                int nodeIdLen = nodeId.size();
                byte[] data = new byte[nodeIdLen + 2];
                ByteConversion.shortToByte((short)((short)nodeId.units()), (byte[])data, (int)0);
                nodeId.serialize(data, 2);
                Term it = new Term("nodeId", new BytesRef(data));
                TermQuery iq = new TermQuery(it);
                BooleanQuery q = new BooleanQuery();
                q.add((Query)tq, BooleanClause.Occur.MUST);
                q.add((Query)iq, BooleanClause.Occur.MUST);
                writer.deleteDocuments(new Query[]{q});
            }
        }
        catch (IOException e) {
            LOG.warn("Error while deleting lucene index entries: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.nodesToRemove = null;
        }
    }

    private NodeId readNodeId(int doc, BinaryDocValues nodeIdValues, BrokerPool pool) {
        BytesRef ref = nodeIdValues.get(doc);
        short units = ByteConversion.byteToShort((byte[])ref.bytes, (int)ref.offset);
        return pool.getNodeFactory().createFromData((int)units, ref.bytes, ref.offset + 2);
    }

    public NodeSet query(XQueryContext context, int contextId, DocumentSet docs, NodeSet contextSet, List<QName> qnames, String queryStr, int axis, Properties options) throws IOException, ParseException, XPathException {
        return (NodeSet)this.index.withSearcher(searcher -> {
            List<QName> definedIndexes = this.getDefinedIndexes(qnames);
            NewArrayNodeSet resultSet = new NewArrayNodeSet();
            boolean returnAncestor = axis == 0;
            for (QName qname : definedIndexes) {
                String field = LuceneUtil.encodeQName(qname, this.index.getBrokerPool().getSymbols());
                Analyzer analyzer = this.getAnalyzer(null, qname, context.getBroker(), docs);
                QueryParserWrapper parser = this.getQueryParser(field, analyzer, docs);
                try {
                    this.setOptions(options, parser.getConfiguration());
                    Query query = parser.parse(queryStr);
                    this.searchAndProcess(contextId, qname, docs, contextSet, (NodeSet)resultSet, returnAncestor, (IndexSearcher)searcher, query, context.getWatchDog());
                }
                catch (ParseException e) {
                    throw new XPathException("Lucene query syntax error: " + e.getMessage());
                }
            }
            return resultSet;
        });
    }

    protected void setOptions(Properties options, CommonQueryParserConfiguration parser) throws ParseException {
        if (options == null) {
            return;
        }
        String option = options.getProperty(OPTION_DEFAULT_OPERATOR);
        if (option != null && parser instanceof QueryParserBase) {
            if (DEFAULT_OPERATOR_OR.equals(option)) {
                ((QueryParserBase)parser).setDefaultOperator(QueryParser.OR_OPERATOR);
            } else {
                ((QueryParserBase)parser).setDefaultOperator(QueryParser.AND_OPERATOR);
            }
        }
        if ((option = options.getProperty(OPTION_LEADING_WILDCARD)) != null) {
            parser.setAllowLeadingWildcard(option.equalsIgnoreCase("yes"));
        }
        if ((option = options.getProperty(OPTION_PHRASE_SLOP)) != null) {
            try {
                int slop = Integer.parseInt(option);
                parser.setPhraseSlop(slop);
            }
            catch (NumberFormatException e) {
                throw new ParseException("value for option phrase-slop needs to be a number");
            }
        }
        if ((option = options.getProperty(OPTION_FILTER_REWRITE)) != null) {
            if (option.equalsIgnoreCase("yes")) {
                parser.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
            } else {
                parser.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
            }
        }
        if ((option = options.getProperty(OPTION_LOWERCASE_EXPANDED_TERMS)) != null) {
            parser.setLowercaseExpandedTerms("yes".equalsIgnoreCase(option));
        }
    }

    public NodeSet query(XQueryContext context, int contextId, DocumentSet docs, NodeSet contextSet, List<QName> qnames, Element queryRoot, int axis, Properties options) throws IOException, ParseException, XPathException {
        return (NodeSet)this.index.withSearcher(searcher -> {
            List<QName> definedIndexes = this.getDefinedIndexes(qnames);
            NewArrayNodeSet resultSet = new NewArrayNodeSet();
            boolean returnAncestor = axis == 0;
            for (QName qname : definedIndexes) {
                String field = LuceneUtil.encodeQName(qname, this.index.getBrokerPool().getSymbols());
                this.analyzer = this.getAnalyzer(null, qname, context.getBroker(), docs);
                Query query = this.queryTranslator.parse(field, queryRoot, this.analyzer, options);
                if (query == null) continue;
                this.searchAndProcess(contextId, qname, docs, contextSet, (NodeSet)resultSet, returnAncestor, (IndexSearcher)searcher, query, context.getWatchDog());
            }
            return resultSet;
        });
    }

    public NodeSet queryField(XQueryContext context, int contextId, DocumentSet docs, NodeSet contextSet, String field, Element queryRoot, int axis, Properties options) throws IOException, XPathException {
        return (NodeSet)this.index.withSearcher(searcher -> {
            NewArrayNodeSet resultSet = new NewArrayNodeSet();
            boolean returnAncestor = axis == 0;
            this.analyzer = this.getAnalyzer(field, null, context.getBroker(), docs);
            Query query = this.queryTranslator.parse(field, queryRoot, this.analyzer, options);
            if (query != null) {
                this.searchAndProcess(contextId, null, docs, contextSet, (NodeSet)resultSet, returnAncestor, (IndexSearcher)searcher, query, context.getWatchDog());
            }
            return resultSet;
        });
    }

    private void searchAndProcess(int contextId, QName qname, DocumentSet docs, NodeSet contextSet, NodeSet resultSet, boolean returnAncestor, IndexSearcher searcher, Query query, XQueryWatchDog watchDog) throws IOException, TerminatedException {
        LuceneHitCollector collector = new LuceneHitCollector(qname, query, docs, contextSet, resultSet, returnAncestor, contextId, watchDog);
        searcher.search(query, (Collector)collector);
    }

    public NodeSet queryField(XQueryContext context, int contextId, DocumentSet docs, NodeSet contextSet, String field, String queryString, int axis, Properties options) throws IOException, ParseException, XPathException {
        return (NodeSet)this.index.withSearcher(searcher -> {
            NewArrayNodeSet resultSet = new NewArrayNodeSet();
            boolean returnAncestor = axis == 0;
            Analyzer analyzer = this.getAnalyzer(field, null, context.getBroker(), docs);
            LOG.debug("Using analyzer " + analyzer + " for " + queryString);
            QueryParserWrapper parser = this.getQueryParser(field, analyzer, docs);
            try {
                this.setOptions(options, parser.getConfiguration());
                Query query = parser.parse(queryString);
                this.searchAndProcess(contextId, null, docs, contextSet, (NodeSet)resultSet, returnAncestor, (IndexSearcher)searcher, query, context.getWatchDog());
            }
            catch (ParseException e) {
                throw new XPathException("Lucene query syntax error: " + e.getMessage());
            }
            return resultSet;
        });
    }

    public void indexNonXML(NodeValue descriptor) {
        if (!descriptor.getNode().getLocalName().contentEquals("doc")) {
            LOG.error("Expected <doc> got <" + descriptor.getNode().getLocalName() + ">");
            return;
        }
        PlainTextIndexConfig solrconfParser = new PlainTextIndexConfig();
        solrconfParser.parse(descriptor);
        if (this.pendingDoc == null) {
            this.pendingDoc = new Document();
            NumericDocValuesField fDocId = new NumericDocValuesField(FIELD_DOC_ID, (long)this.currentDoc.getDocId());
            this.pendingDoc.add((IndexableField)fDocId);
            IntField fDocIdIdx = new IntField(FIELD_DOC_ID, this.currentDoc.getDocId(), Field.Store.NO);
            this.pendingDoc.add((IndexableField)fDocIdIdx);
            String uri = this.currentDoc.getURI().toString();
            Field fDocUri = new Field(FIELD_DOC_URI, uri, Field.Store.YES, Field.Index.NOT_ANALYZED);
            this.pendingDoc.add((IndexableField)fDocUri);
        }
        for (PlainTextIndexConfig.PlainTextField field : solrconfParser.getFields()) {
            FieldType fieldType = this.config == null ? null : this.config.getFieldType(field.getName());
            Field.Store store = null;
            if (fieldType != null) {
                store = fieldType.getStore();
            }
            if (store == null) {
                store = field.getStore();
            }
            String contentFieldName = field.getName();
            Analyzer fieldAnalyzer = fieldType == null ? null : fieldType.getAnalyzer();
            Field contentField = new Field(contentFieldName, field.getData().toString(), store, Field.Index.ANALYZED, Field.TermVector.YES);
            if (field.getBoost() > 0.0f) {
                contentField.setBoost(field.getBoost());
            }
            this.pendingDoc.add((IndexableField)contentField);
        }
    }

    public void writeNonXML() {
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            writer.addDocument((Iterable)this.pendingDoc);
        }
        catch (IOException e) {
            LOG.warn("An exception was caught while indexing document: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.pendingDoc = null;
            this.cachedNodesSize = 0;
        }
    }

    public org.exist.dom.memtree.NodeImpl search(final XQueryContext context, final List<String> toBeMatchedURIs, String queryText, String[] fieldsToGet) throws XPathException, IOException {
        return (org.exist.dom.memtree.NodeImpl)this.index.withSearcher(searcher -> {
            StandardAnalyzer searchAnalyzer = new StandardAnalyzer(LuceneIndex.LUCENE_VERSION_IN_USE);
            QueryParserWrapper parser = this.getQueryParser("", (Analyzer)searchAnalyzer, null);
            Query query = parser.parse(queryText);
            final String[] fields = fieldsToGet == null ? LuceneUtil.extractFields(query, searcher.getIndexReader()) : fieldsToGet;
            final PlainTextHighlighter highlighter = new PlainTextHighlighter(query, searcher.getIndexReader());
            final MemTreeBuilder builder = new MemTreeBuilder();
            builder.startDocument();
            int nodeNr = builder.startElement("", "results", "results", null);
            searcher.search(query, new Collector((Analyzer)searchAnalyzer){
                private Scorer scorer;
                private AtomicReader reader;
                final /* synthetic */ Analyzer val$searchAnalyzer;
                {
                    this.val$searchAnalyzer = analyzer;
                }

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void collect(int docNum) throws IOException {
                    Document doc = this.reader.document(docNum);
                    String fDocUri = doc.get(LuceneIndexWorker.FIELD_DOC_URI);
                    float score = this.scorer.score();
                    if (LuceneIndexWorker.this.isDocumentMatch(fDocUri, toBeMatchedURIs)) {
                        DocumentImpl storedDoc = null;
                        try {
                            storedDoc = context.getBroker().getXMLResource(XmldbURI.createInternal((String)fDocUri), Lock.LockMode.READ_LOCK);
                            if (storedDoc == null) {
                                return;
                            }
                            AttributesImpl attribs = new AttributesImpl();
                            attribs.addAttribute("", "uri", "uri", "CDATA", fDocUri);
                            attribs.addAttribute("", "score", "score", "CDATA", "" + score);
                            builder.startElement("", "search", "search", (Attributes)attribs);
                            for (String field : fields) {
                                String[] fieldContent = doc.getValues(field);
                                attribs.clear();
                                attribs.addAttribute("", "name", "name", "CDATA", field);
                                for (String content : fieldContent) {
                                    List<PlainTextHighlighter.Offset> offsets = highlighter.getOffsets(content, this.val$searchAnalyzer);
                                    builder.startElement("", "field", "field", (Attributes)attribs);
                                    if (offsets != null) {
                                        highlighter.highlight(content, offsets, builder);
                                    } else {
                                        builder.characters((CharSequence)content);
                                    }
                                    builder.endElement();
                                }
                            }
                            builder.endElement();
                            attribs.clear();
                        }
                        catch (PermissionDeniedException permissionDeniedException) {
                        }
                        finally {
                            if (storedDoc != null) {
                                storedDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                            }
                        }
                    }
                }

                public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
                    this.reader = atomicReaderContext.reader();
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }
            });
            builder.endElement();
            return builder.getDocument().getNode(nodeNr);
        });
    }

    public String getFieldContent(int docId, String field) throws IOException {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded((int)docId, (int)0, (BytesRefBuilder)bytes);
        Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
        return (String)this.index.withReader(reader -> {
            List leaves = reader.leaves();
            for (AtomicReaderContext context : leaves) {
                Document doc;
                String value;
                AtomicReader atomicReader = context.reader();
                DocsEnum docs = atomicReader.termDocsEnum(dt);
                if (docs == null || docs.nextDoc() == Integer.MAX_VALUE || (value = (doc = atomicReader.document(docs.docID())).get(field)) == null) continue;
                return value;
            }
            return null;
        });
    }

    public boolean hasIndex(int docId) throws IOException {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded((int)docId, (int)0, (BytesRefBuilder)bytes);
        Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
        return (Boolean)this.index.withReader(reader -> {
            boolean found = false;
            List leaves = reader.leaves();
            for (AtomicReaderContext context : leaves) {
                DocsEnum docs = context.reader().termDocsEnum(dt);
                if (docs == null || docs.nextDoc() == Integer.MAX_VALUE) continue;
                found = true;
                break;
            }
            return found;
        });
    }

    private boolean isDocumentMatch(String docUri, List<String> toBeMatchedUris) {
        if (docUri == null) {
            LOG.error("docUri is null.");
            return false;
        }
        if (toBeMatchedUris == null) {
            LOG.error("match is null.");
            return false;
        }
        for (String doc : toBeMatchedUris) {
            if (!docUri.startsWith(doc)) continue;
            return true;
        }
        return false;
    }

    public List<QName> getDefinedIndexes(List<QName> qnames) throws IOException {
        ArrayList<QName> indexes = new ArrayList<QName>(20);
        if (qnames != null && !qnames.isEmpty()) {
            for (QName qname : qnames) {
                if (qname.getLocalPart() == null || qname.getNamespaceURI() == null) {
                    this.getDefinedIndexesFor(qname, indexes);
                    continue;
                }
                indexes.add(qname);
            }
            return indexes;
        }
        return this.getDefinedIndexesFor(null, indexes);
    }

    private List<QName> getDefinedIndexesFor(QName qname, List<QName> indexes) throws IOException {
        return (List)this.index.withReader(reader -> {
            for (FieldInfo info : MultiFields.getMergedFieldInfos((IndexReader)reader)) {
                QName name;
                if (FIELD_DOC_ID.equals(info.name) || (name = LuceneUtil.decodeQName(info.name, this.index.getBrokerPool().getSymbols())) == null || qname != null && !LuceneIndexWorker.matchQName(qname, name)) continue;
                indexes.add(name);
            }
            return indexes;
        });
    }

    private static boolean matchQName(QName qname, QName candidate) {
        boolean match = true;
        if (qname.getLocalPart() != null) {
            match = qname.getLocalPart().equals(candidate.getLocalPart());
        }
        if (match && qname.getNamespaceURI() != null && qname.getNamespaceURI().length() > 0) {
            match = qname.getNamespaceURI().equals(candidate.getNamespaceURI());
        }
        return match;
    }

    protected Analyzer getAnalyzer(String field, QName qname, DBBroker broker, DocumentSet docs) {
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Analyzer analyzer;
            LuceneConfig config;
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(broker);
            if (idxConf == null || (config = (LuceneConfig)idxConf.getCustomIndexSpec(LuceneIndex.ID)) == null || (analyzer = field == null ? config.getAnalyzer(qname) : config.getAnalyzer(field)) == null) continue;
            return analyzer;
        }
        return this.index.getDefaultAnalyzer();
    }

    protected QueryParserWrapper getQueryParser(String field, Analyzer analyzer, DocumentSet docs) {
        if (docs != null) {
            Iterator i = docs.getCollectionIterator();
            while (i.hasNext()) {
                QueryParserWrapper parser;
                LuceneConfig config;
                Collection collection = (Collection)i.next();
                IndexSpec idxConf = collection.getIndexConfiguration(this.broker);
                if (idxConf == null || (config = (LuceneConfig)idxConf.getCustomIndexSpec(LuceneIndex.ID)) == null || (parser = config.getQueryParser(field, analyzer)) == null) continue;
                return parser;
            }
        }
        return new ClassicQueryParserWrapper(field, analyzer);
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet nodes, Map<?, ?> hints) {
        try {
            List<QName> qnames = hints == null ? null : (List<QName>)hints.get("qnames_key");
            qnames = this.getDefinedIndexes(qnames);
            String start = null;
            String end = null;
            long max = Long.MAX_VALUE;
            if (hints != null) {
                Object vstart = hints.get("start_value");
                Object vend = hints.get("end_value");
                start = vstart == null ? null : vstart.toString();
                end = vend == null ? null : vend.toString();
                IntegerValue vmax = (IntegerValue)hints.get("value_count");
                max = vmax == null ? Long.MAX_VALUE : vmax.getValue();
            }
            return this.scanIndexByQName(qnames, docs, nodes, start, end, max);
        }
        catch (IOException e) {
            LOG.warn("Failed to scan index occurrences: " + e.getMessage(), (Throwable)e);
            return new Occurrences[0];
        }
    }

    private Occurrences[] scanIndexByQName(List<QName> qnames, DocumentSet docs, NodeSet nodes, String start, String end, long max) throws IOException {
        TreeMap map = new TreeMap();
        this.index.withReader(reader -> {
            for (QName qname : qnames) {
                String field = LuceneUtil.encodeQName(qname, this.index.getBrokerPool().getSymbols());
                List leaves = reader.leaves();
                block1: for (AtomicReaderContext context : leaves) {
                    TermsEnum termsIter;
                    NumericDocValues docIdValues = context.reader().getNumericDocValues(FIELD_DOC_ID);
                    BinaryDocValues nodeIdValues = context.reader().getBinaryDocValues("nodeId");
                    Bits liveDocs = context.reader().getLiveDocs();
                    Terms terms = context.reader().terms(field);
                    if (terms == null || (termsIter = terms.iterator(null)).next() == null) continue;
                    while ((long)map.size() < max) {
                        BytesRef ref = termsIter.term();
                        String term = ref.utf8ToString();
                        boolean include = true;
                        if (end != null) {
                            if (term.compareTo(end) > 0) {
                                include = false;
                            }
                        } else if (start != null && !term.startsWith(start)) {
                            include = false;
                        }
                        if (include) {
                            DocsEnum docsEnum = termsIter.docs(null, null);
                            while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                                int docId;
                                DocumentImpl storedDocument;
                                if (liveDocs != null && !liveDocs.get(docsEnum.docID()) || (storedDocument = docs.getDoc(docId = (int)docIdValues.get(docsEnum.docID()))) == null) continue;
                                NodeId nodeId = null;
                                if (nodes != null) {
                                    BytesRef nodeIdRef = nodeIdValues.get(docsEnum.docID());
                                    short units = ByteConversion.byteToShort((byte[])nodeIdRef.bytes, (int)nodeIdRef.offset);
                                    nodeId = this.index.getBrokerPool().getNodeFactory().createFromData((int)units, nodeIdRef.bytes, nodeIdRef.offset + 2);
                                }
                                if (nodeId != null && nodes.get(storedDocument, nodeId) == null) continue;
                                Occurrences oc = (Occurrences)map.get(term);
                                if (oc == null) {
                                    oc = new Occurrences((Comparable)((Object)term));
                                    map.put(term, oc);
                                }
                                oc.addDocument(storedDocument);
                                oc.addOccurrences(docsEnum.freq());
                            }
                        }
                        if (termsIter.next() != null) continue;
                        continue block1;
                    }
                }
            }
            return null;
        });
        Occurrences[] occur = new Occurrences[map.size()];
        return map.values().toArray(occur);
    }

    protected void indexText(NodeId nodeId, QName qname, NodePath path, LuceneIndexConfig config, CharSequence content) {
        PendingDoc pending = new PendingDoc(nodeId, qname, path, content, config.getBoost(), config);
        this.addPending(pending);
    }

    protected void indexText(java.util.Collection<AttrImpl> attribs, NodeId nodeId, QName qname, NodePath path, LuceneIndexConfig config, CharSequence content) {
        PendingDoc pending = new PendingDoc(nodeId, qname, path, content, config.getAttrBoost(attribs), config);
        this.addPending(pending);
    }

    private void addPending(PendingDoc pending) {
        this.nodesToWrite.add(pending);
        this.cachedNodesSize += pending.text.length();
        if (this.cachedNodesSize > this.maxCachedNodesSize) {
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        if (this.nodesToWrite == null || this.nodesToWrite.isEmpty()) {
            return;
        }
        if (this.broker.getIndexController().isReindexing()) {
            this.nodesToRemove = new TreeSet<NodeId>();
            for (PendingDoc p : this.nodesToWrite) {
                this.nodesToRemove.add(p.nodeId);
            }
            this.removeNodes();
        }
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            NumericDocValuesField fDocId = new NumericDocValuesField(FIELD_DOC_ID, 0L);
            BinaryDocValuesField fNodeId = new BinaryDocValuesField("nodeId", new BytesRef(8));
            IntField fDocIdIdx = new IntField(FIELD_DOC_ID, 0, IntField.TYPE_NOT_STORED);
            final ArrayList metas = new ArrayList();
            this.broker.getIndexController().streamMetas(new MetaStreamListener(){

                public void metadata(QName key, Object value) {
                    if (value instanceof String) {
                        String name = key.getLocalPart();
                        Field fld = new Field(name, value.toString(), Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES);
                        metas.add(fld);
                    }
                }
            });
            for (PendingDoc pending : this.nodesToWrite) {
                Document doc = new Document();
                fDocId.setLongValue((long)this.currentDoc.getDocId());
                doc.add((IndexableField)fDocId);
                int nodeIdLen = pending.nodeId.size();
                byte[] data = new byte[nodeIdLen + 2];
                ByteConversion.shortToByte((short)((short)pending.nodeId.units()), (byte[])data, (int)0);
                pending.nodeId.serialize(data, 2);
                fNodeId.setBytesValue(data);
                doc.add((IndexableField)fNodeId);
                BinaryTokenStream bts = new BinaryTokenStream(new BytesRef(data));
                Field fNodeIdIdx = new Field("nodeId", (TokenStream)bts, TYPE_NODE_ID);
                doc.add((IndexableField)fNodeIdIdx);
                String contentField = pending.idxConf.isNamed() ? pending.idxConf.getName() : LuceneUtil.encodeQName(pending.qname, this.index.getBrokerPool().getSymbols());
                Field fld = new Field(contentField, pending.text.toString(), Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES);
                if (pending.boost > 0.0f) {
                    fld.setBoost(pending.boost);
                } else if (this.config.getBoost() > 0.0f) {
                    fld.setBoost(this.config.getBoost());
                }
                doc.add((IndexableField)fld);
                fDocIdIdx.setIntValue(this.currentDoc.getDocId());
                doc.add((IndexableField)fDocIdIdx);
                for (Field meta : metas) {
                    doc.add((IndexableField)meta);
                }
                byte[] docNodeId = LuceneUtil.createId(this.currentDoc.getDocId(), pending.nodeId);
                StoredField fDocNodeId = new StoredField("docNodeId", docNodeId);
                doc.add((IndexableField)fDocNodeId);
                if (pending.idxConf.getAnalyzer() == null) {
                    writer.addDocument((Iterable)doc);
                    continue;
                }
                writer.addDocument((Iterable)doc, pending.idxConf.getAnalyzer());
            }
        }
        catch (IOException e) {
            LOG.warn("An exception was caught while indexing document: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.nodesToWrite = new ArrayList<PendingDoc>();
            this.cachedNodesSize = 0;
        }
    }

    public void optimize() {
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter(true);
            writer.forceMerge(1, true);
            writer.commit();
        }
        catch (IOException e) {
            LOG.warn("An exception was caught while optimizing the lucene index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
        }
    }

    static {
        TYPE_NODE_ID.setIndexed(true);
        TYPE_NODE_ID.setStored(false);
        TYPE_NODE_ID.setOmitNorms(true);
        TYPE_NODE_ID.setStoreTermVectors(false);
        TYPE_NODE_ID.setTokenized(true);
        LOG = LogManager.getLogger(LuceneIndexWorker.class);
    }

    public class LuceneMatch
    extends Match {
        private float score;
        private final Query query;

        public LuceneMatch(int contextId, NodeId nodeId, Query query) {
            super(contextId, nodeId, null);
            this.score = 0.0f;
            this.query = query;
        }

        public LuceneMatch(LuceneMatch copy) {
            super((Match)copy);
            this.score = 0.0f;
            this.score = copy.score;
            this.query = copy.query;
        }

        public Match createInstance(int contextId, NodeId nodeId, String matchTerm) {
            return null;
        }

        public Match createInstance(int contextId, NodeId nodeId, Query query) {
            return new LuceneMatch(contextId, nodeId, query);
        }

        public Match newCopy() {
            return new LuceneMatch(this);
        }

        public String getIndexId() {
            return LuceneIndex.ID;
        }

        public Query getQuery() {
            return this.query;
        }

        public float getScore() {
            return this.score;
        }

        protected void setScore(float score) {
            this.score = score;
        }

        public boolean equals(Object other) {
            if (!(other instanceof LuceneMatch)) {
                return false;
            }
            LuceneMatch o = (LuceneMatch)((Object)other);
            return (this.nodeId == o.nodeId || this.nodeId.equals(o.nodeId)) && this.query == ((LuceneMatch)((Object)other)).query;
        }

        public boolean matchEquals(Match other) {
            return this.equals(other);
        }
    }

    private class LuceneStreamListener
    extends AbstractStreamListener {
        private ArrayList<PendingAttr> pendingAttrs = new ArrayList();
        private ArrayList<AttrImpl> attributes = new ArrayList(10);
        private ElementImpl currentElement;

        private LuceneStreamListener() {
        }

        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            if (this.currentElement != null) {
                this.indexPendingAttrs();
            }
            this.currentElement = element;
            if (LuceneIndexWorker.this.mode == StreamListener.ReindexMode.STORE && LuceneIndexWorker.this.config != null) {
                Iterator<LuceneIndexConfig> configIter;
                if (LuceneIndexWorker.this.contentStack != null && !LuceneIndexWorker.this.contentStack.isEmpty()) {
                    for (TextExtractor extractor : LuceneIndexWorker.this.contentStack) {
                        extractor.startElement(element.getQName());
                    }
                }
                if ((configIter = LuceneIndexWorker.this.config.getConfig(path)) != null) {
                    if (LuceneIndexWorker.this.contentStack == null) {
                        LuceneIndexWorker.this.contentStack = new Stack();
                    }
                    while (configIter.hasNext()) {
                        LuceneIndexConfig configuration = configIter.next();
                        if (!configuration.match(path)) continue;
                        DefaultTextExtractor extractor = new DefaultTextExtractor();
                        extractor.configure(LuceneIndexWorker.this.config, configuration);
                        LuceneIndexWorker.this.contentStack.push(extractor);
                    }
                }
            }
            super.startElement(transaction, element, path);
        }

        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            if (LuceneIndexWorker.this.config != null) {
                if (LuceneIndexWorker.this.mode == StreamListener.ReindexMode.STORE && LuceneIndexWorker.this.contentStack != null && !LuceneIndexWorker.this.contentStack.isEmpty()) {
                    for (TextExtractor extractor : LuceneIndexWorker.this.contentStack) {
                        extractor.endElement(element.getQName());
                    }
                }
                Iterator<LuceneIndexConfig> configIter = LuceneIndexWorker.this.config.getConfig(path);
                if (LuceneIndexWorker.this.mode != StreamListener.ReindexMode.REMOVE_ALL_NODES && configIter != null) {
                    if (LuceneIndexWorker.this.mode == StreamListener.ReindexMode.REMOVE_SOME_NODES) {
                        LuceneIndexWorker.this.nodesToRemove.add(element.getNodeId());
                    } else {
                        while (configIter.hasNext()) {
                            LuceneIndexConfig configuration = configIter.next();
                            if (!configuration.match(path)) continue;
                            TextExtractor extractor = (TextExtractor)LuceneIndexWorker.this.contentStack.pop();
                            if (configuration.shouldReindexOnAttributeChange()) {
                                boolean wasEmpty = false;
                                if (this.attributes.isEmpty()) {
                                    wasEmpty = true;
                                    NamedNodeMap attributes1 = element.getAttributes();
                                    for (int i = 0; i < attributes1.getLength(); ++i) {
                                        this.attributes.add((AttrImpl)attributes1.item(i));
                                    }
                                }
                                LuceneIndexWorker.this.indexText(this.attributes, element.getNodeId(), element.getQName(), path, extractor.getIndexConfig(), (CharSequence)extractor.getText());
                                if (!wasEmpty) continue;
                                this.attributes.clear();
                                continue;
                            }
                            LuceneIndexWorker.this.indexText(element.getNodeId(), element.getQName(), path, extractor.getIndexConfig(), (CharSequence)extractor.getText());
                        }
                    }
                }
            }
            this.indexPendingAttrs();
            this.currentElement = null;
            super.endElement(transaction, element, path);
        }

        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            path.addComponent(attrib.getQName());
            AttrImpl attribCopy = null;
            if (LuceneIndexWorker.this.mode == StreamListener.ReindexMode.STORE && this.currentElement != null) {
                attribCopy = (AttrImpl)NodePool.getInstance().borrowNode((short)2);
                attribCopy.setValue(attrib.getValue());
                attribCopy.setNodeId(attrib.getNodeId());
                attribCopy.setQName(attrib.getQName());
                this.attributes.add(attribCopy);
            }
            Iterator<LuceneIndexConfig> configIter = null;
            if (LuceneIndexWorker.this.config != null) {
                configIter = LuceneIndexWorker.this.config.getConfig(path);
            }
            if (LuceneIndexWorker.this.mode != StreamListener.ReindexMode.REMOVE_ALL_NODES && configIter != null) {
                if (LuceneIndexWorker.this.mode == StreamListener.ReindexMode.REMOVE_SOME_NODES) {
                    LuceneIndexWorker.this.nodesToRemove.add(attrib.getNodeId());
                } else {
                    while (configIter.hasNext()) {
                        LuceneIndexConfig configuration = configIter.next();
                        if (!configuration.match(path)) continue;
                        if (configuration.shouldReindexOnAttributeChange()) {
                            this.appendAttrToBeIndexedLater(attribCopy, new NodePath(path), configuration);
                            continue;
                        }
                        LuceneIndexWorker.this.indexText(attrib.getNodeId(), attrib.getQName(), path, configuration, attrib.getValue());
                    }
                }
            }
            path.removeLastComponent();
            super.attribute(transaction, attrib, path);
        }

        public void characters(Txn transaction, AbstractCharacterData text, NodePath path) {
            if (LuceneIndexWorker.this.contentStack != null && !LuceneIndexWorker.this.contentStack.isEmpty()) {
                for (TextExtractor extractor : LuceneIndexWorker.this.contentStack) {
                    extractor.beforeCharacters();
                    extractor.characters(text.getXMLString());
                }
            }
            super.characters(transaction, text, path);
        }

        public IndexWorker getWorker() {
            return LuceneIndexWorker.this;
        }

        private void appendAttrToBeIndexedLater(AttrImpl attr, NodePath path, LuceneIndexConfig conf) {
            if (this.currentElement == null) {
                LOG.error("currentElement == null");
            } else {
                this.pendingAttrs.add(new PendingAttr(attr, path, conf));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void indexPendingAttrs() {
            try {
                if (LuceneIndexWorker.this.mode == StreamListener.ReindexMode.STORE && LuceneIndexWorker.this.config != null) {
                    for (PendingAttr pending : this.pendingAttrs) {
                        AttrImpl attr = pending.attr;
                        LuceneIndexWorker.this.indexText(this.attributes, attr.getNodeId(), attr.getQName(), pending.path, pending.conf, attr.getValue());
                    }
                }
            }
            finally {
                this.pendingAttrs.clear();
                this.releaseAttributes();
            }
        }

        private void releaseAttributes() {
            try {
                for (Attr attr : this.attributes) {
                    NodePool.getInstance().returnNode((NodeImpl)((AttrImpl)attr));
                }
            }
            finally {
                this.attributes.clear();
            }
        }
    }

    private static class PendingAttr {
        AttrImpl attr;
        LuceneIndexConfig conf;
        NodePath path;

        public PendingAttr(AttrImpl attr, NodePath path, LuceneIndexConfig conf) {
            this.attr = attr;
            this.conf = conf;
            this.path = path;
        }
    }

    private static class PendingDoc {
        NodeId nodeId;
        CharSequence text;
        QName qname;
        LuceneIndexConfig idxConf;
        float boost;

        private PendingDoc(NodeId nodeId, QName qname, NodePath path, CharSequence text, float boost, LuceneIndexConfig idxConf) {
            this.nodeId = nodeId;
            this.qname = qname;
            this.text = text;
            this.idxConf = idxConf;
            this.boost = boost;
        }
    }

    private class LuceneHitCollector
    extends Collector {
        private Scorer scorer;
        private AtomicReader reader;
        private NumericDocValues docIdValues;
        private BinaryDocValues nodeIdValues;
        private final byte[] buf = new byte[1024];
        private final QName qname;
        private final DocumentSet docs;
        private final NodeSet contextSet;
        private final NodeSet resultSet;
        private final boolean returnAncestor;
        private final int contextId;
        private final Query query;
        private final XQueryWatchDog watchdog;

        private LuceneHitCollector(QName qname, Query query, DocumentSet docs, NodeSet contextSet, NodeSet resultSet, boolean returnAncestor, int contextId, XQueryWatchDog watchDog) {
            this.qname = qname;
            this.docs = docs;
            this.contextSet = contextSet;
            this.resultSet = resultSet;
            this.returnAncestor = returnAncestor;
            this.contextId = contextId;
            this.query = query;
            this.watchdog = watchDog;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
            this.reader = atomicReaderContext.reader();
            this.docIdValues = this.reader.getNumericDocValues(LuceneIndexWorker.FIELD_DOC_ID);
            this.nodeIdValues = this.reader.getBinaryDocValues("nodeId");
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void collect(int doc) {
            try {
                float score = this.scorer.score();
                int docId = (int)this.docIdValues.get(doc);
                DocumentImpl storedDocument = this.docs.getDoc(docId);
                if (storedDocument == null) {
                    return;
                }
                BytesRef ref = this.nodeIdValues.get(doc);
                short units = ByteConversion.byteToShort((byte[])ref.bytes, (int)ref.offset);
                NodeId nodeId = LuceneIndexWorker.this.index.getBrokerPool().getNodeFactory().createFromData((int)units, ref.bytes, ref.offset + 2);
                NodeProxy storedNode = new NodeProxy(storedDocument, nodeId);
                if (this.qname != null) {
                    storedNode.setNodeType(this.qname.getNameType() == 1 ? (short)2 : 1);
                }
                if (this.contextSet != null) {
                    int sizeHint = this.contextSet.getSizeHint(storedDocument);
                    if (this.returnAncestor) {
                        NodeProxy parentNode = this.contextSet.get(storedNode);
                        if (parentNode != null) {
                            LuceneMatch match = new LuceneMatch(this.contextId, nodeId, this.query);
                            match.setScore(score);
                            parentNode.addMatch((Match)match);
                            this.resultSet.add(parentNode, sizeHint);
                            if (-1 != this.contextId) {
                                parentNode.deepCopyContext(storedNode, this.contextId);
                            } else {
                                parentNode.copyContext(storedNode);
                            }
                        }
                    } else {
                        LuceneMatch match = new LuceneMatch(this.contextId, nodeId, this.query);
                        match.setScore(score);
                        storedNode.addMatch((Match)match);
                        this.resultSet.add(storedNode, sizeHint);
                    }
                } else {
                    LuceneMatch match = new LuceneMatch(this.contextId, nodeId, this.query);
                    match.setScore(score);
                    storedNode.addMatch((Match)match);
                    this.resultSet.add(storedNode);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

