/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.AttributeSource;
import org.exist.dom.QName;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.AbstractMatchListener;
import org.exist.indexing.lucene.DefaultTextExtractor;
import org.exist.indexing.lucene.LuceneConfig;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexConfig;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.indexing.lucene.LuceneUtil;
import org.exist.indexing.lucene.MarkableTokenFilter;
import org.exist.numbering.NodeId;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.util.serializer.AttrList;
import org.xml.sax.SAXException;

public class LuceneMatchListener
extends AbstractMatchListener {
    private static final Logger LOG = LogManager.getLogger(LuceneMatchListener.class);
    private Match match;
    private Map<Object, Query> termMap;
    private Map<NodeId, Offset> nodesWithMatch;
    private final LuceneIndex index;
    private LuceneConfig config;
    private DBBroker broker;

    public LuceneMatchListener(LuceneIndex index, DBBroker broker, NodeProxy proxy) {
        this.index = index;
        this.reset(broker, proxy);
    }

    public boolean hasMatches(NodeProxy proxy) {
        for (Match nextMatch = proxy.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (nextMatch.getIndexId() != LuceneIndex.ID) continue;
            return true;
        }
        return false;
    }

    protected void reset(DBBroker broker, NodeProxy proxy) {
        this.broker = broker;
        this.match = proxy.getMatches();
        this.setNextInChain(null);
        IndexSpec indexConf = proxy.getOwnerDocument().getCollection().getIndexConfiguration(broker);
        if (indexConf != null) {
            this.config = (LuceneConfig)indexConf.getCustomIndexSpec(LuceneIndex.ID);
        }
        this.getTerms();
        this.nodesWithMatch = new TreeMap<NodeId, Offset>();
        NewArrayNodeSet ancestors = null;
        for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (!proxy.getNodeId().isDescendantOf(nextMatch.getNodeId())) continue;
            if (ancestors == null) {
                ancestors = new NewArrayNodeSet();
            }
            ancestors.add(new NodeProxy(proxy.getOwnerDocument(), nextMatch.getNodeId()));
        }
        if (ancestors != null && !ancestors.isEmpty()) {
            for (NodeProxy p : ancestors) {
                this.scanMatches(p);
            }
        }
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (!nextMatch.getNodeId().equals(this.getCurrentNode().getNodeId())) continue;
            this.scanMatches(new NodeProxy(this.getCurrentNode()));
            break;
        }
        super.startElement(qname, attribs);
    }

    public void characters(CharSequence seq) throws SAXException {
        NodeId nodeId = this.getCurrentNode().getNodeId();
        Offset offset = this.nodesWithMatch.get(nodeId);
        if (offset == null) {
            super.characters(seq);
        } else {
            String s = seq.toString();
            int pos = 0;
            while (offset != null) {
                int end;
                if (offset.startOffset > pos) {
                    if (offset.startOffset > seq.length()) {
                        throw new SAXException("start offset out of bounds");
                    }
                    super.characters((CharSequence)s.substring(pos, offset.startOffset));
                }
                if ((end = offset.endOffset) > s.length()) {
                    end = s.length();
                }
                super.startElement(MATCH_ELEMENT, null);
                super.characters((CharSequence)s.substring(offset.startOffset, end));
                super.endElement(MATCH_ELEMENT);
                pos = end;
                offset = offset.next;
            }
            if (pos < seq.length()) {
                super.characters((CharSequence)s.substring(pos));
            }
        }
    }

    private void scanMatches(NodeProxy p) {
        NodePath path = this.getPath(p);
        LuceneIndexConfig idxConf = this.config.getConfig(path).next();
        DefaultTextExtractor extractor = new DefaultTextExtractor();
        extractor.configure(this.config, idxConf);
        OffsetList offsets = new OffsetList();
        int level = 0;
        int textOffset = 0;
        try {
            IEmbeddedXMLStreamReader reader = this.broker.getXMLStreamReader((NodeHandle)p, false);
            while (reader.hasNext()) {
                int ev = reader.next();
                switch (ev) {
                    case 2: {
                        if (--level < 0 || level <= 0) break;
                        textOffset += extractor.endElement(reader.getQName());
                        break;
                    }
                    case 1: {
                        if (level > 0) {
                            textOffset += extractor.startElement(reader.getQName());
                        }
                        ++level;
                        break;
                    }
                    case 4: {
                        NodeId nodeId = (NodeId)reader.getProperty("node-id");
                        offsets.add(textOffset += extractor.beforeCharacters(), nodeId);
                        textOffset += extractor.characters(reader.getXMLText());
                    }
                }
            }
        }
        catch (IOException | XMLStreamException e) {
            LOG.warn("Problem found while serializing XML: " + e.getMessage(), (Throwable)e);
        }
        Analyzer analyzer = idxConf.getAnalyzer();
        if (analyzer == null) {
            analyzer = this.index.getDefaultAnalyzer();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Analyzer: " + analyzer + " for path: " + path);
        }
        String str = extractor.getText().toString();
        try (TokenStream tokenStream = analyzer.tokenStream(null, (Reader)new StringReader(str));){
            tokenStream.reset();
            MarkableTokenFilter stream = new MarkableTokenFilter(tokenStream);
            while (stream.incrementToken()) {
                String text = ((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString();
                Query query = this.termMap.get(text);
                if (query == null) continue;
                if (query instanceof PhraseQuery) {
                    PhraseQuery phraseQuery = (PhraseQuery)query;
                    Term[] terms = phraseQuery.getTerms();
                    if (!text.equals(terms[0].text())) continue;
                    stream.mark();
                    int t = 1;
                    ArrayList<AttributeSource.State> stateList = new ArrayList<AttributeSource.State>(terms.length);
                    stateList.add(stream.captureState());
                    while (stream.incrementToken() && t < terms.length && (text = ((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString()).equals(terms[t].text())) {
                        stateList.add(stream.captureState());
                        if (++t != terms.length) continue;
                    }
                    if (stateList.size() != terms.length) continue;
                    int lastIdx = -1;
                    for (int i = 0; i < terms.length; ++i) {
                        stream.restoreState((AttributeSource.State)stateList.get(i));
                        OffsetAttribute offsetAttr = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
                        int idx = offsets.getIndex(offsetAttr.startOffset());
                        NodeId nodeId = offsets.ids[idx];
                        Offset offset = this.nodesWithMatch.get(nodeId);
                        if (offset != null) {
                            if (lastIdx == idx) {
                                offset.setEndOffset(offsetAttr.endOffset() - offsets.offsets[idx]);
                            } else {
                                offset.add(offsetAttr.startOffset() - offsets.offsets[idx], offsetAttr.endOffset() - offsets.offsets[idx]);
                            }
                        } else {
                            this.nodesWithMatch.put(nodeId, new Offset(offsetAttr.startOffset() - offsets.offsets[idx], offsetAttr.endOffset() - offsets.offsets[idx]));
                        }
                        lastIdx = idx;
                    }
                    continue;
                }
                OffsetAttribute offsetAttr = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
                int idx = offsets.getIndex(offsetAttr.startOffset());
                NodeId nodeId = offsets.ids[idx];
                Offset offset = this.nodesWithMatch.get(nodeId);
                if (offset != null) {
                    offset.add(offsetAttr.startOffset() - offsets.offsets[idx], offsetAttr.endOffset() - offsets.offsets[idx]);
                    continue;
                }
                this.nodesWithMatch.put(nodeId, new Offset(offsetAttr.startOffset() - offsets.offsets[idx], offsetAttr.endOffset() - offsets.offsets[idx]));
            }
        }
        catch (IOException e) {
            LOG.warn("Problem found while serializing XML: " + e.getMessage(), (Throwable)e);
        }
    }

    private NodePath getPath(NodeProxy proxy) {
        NodePath path = new NodePath();
        IStoredNode node = (IStoredNode)proxy.getNode();
        this.walkAncestor(node, path);
        return path;
    }

    private void walkAncestor(IStoredNode node, NodePath path) {
        if (node == null) {
            return;
        }
        IStoredNode parent = node.getParentStoredNode();
        this.walkAncestor(parent, path);
        path.addComponent(node.getQName());
    }

    private void getTerms() {
        try {
            this.index.withReader(reader -> {
                HashSet<Query> queries = new HashSet<Query>();
                this.termMap = new TreeMap<Object, Query>();
                for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                    Query query;
                    if (nextMatch.getIndexId() != LuceneIndex.ID || queries.contains(query = ((LuceneIndexWorker.LuceneMatch)nextMatch).getQuery())) continue;
                    queries.add(query);
                    LuceneUtil.extractTerms(query, this.termMap, reader, false);
                }
                return null;
            });
        }
        catch (IOException e) {
            LOG.warn("Match listener caught IO exception while reading query tersm: " + e.getMessage(), (Throwable)e);
        }
    }

    private class Offset {
        int startOffset;
        int endOffset;
        Offset next = null;

        Offset(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        void add(int offset, int endOffset) {
            if (this.startOffset == offset) {
                return;
            }
            this.getLast().next = new Offset(offset, endOffset);
        }

        private Offset getLast() {
            Offset next = this;
            while (next.next != null) {
                next = next.next;
            }
            return next;
        }

        void setEndOffset(int offset) {
            this.getLast().endOffset = offset;
        }
    }

    private static class OffsetList {
        int[] offsets = new int[16];
        NodeId[] ids = new NodeId[16];
        int len = 0;

        private OffsetList() {
        }

        void add(int offset, NodeId nodeId) {
            if (this.len == this.offsets.length) {
                int[] tempOffsets = new int[this.len * 2];
                System.arraycopy(this.offsets, 0, tempOffsets, 0, this.len);
                this.offsets = tempOffsets;
                NodeId[] tempIds = new NodeId[this.len * 2];
                System.arraycopy(this.ids, 0, tempIds, 0, this.len);
                this.ids = tempIds;
            }
            this.offsets[this.len] = offset;
            this.ids[this.len++] = nodeId;
        }

        int getIndex(int offset) {
            for (int i = 0; i < this.len; ++i) {
                if (this.offsets[i] > offset || i + 1 != this.len && this.offsets[i + 1] <= offset) continue;
                return i;
            }
            return -1;
        }
    }
}

