/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.xquery.XPathException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLToQuery {
    private final LuceneIndex index;

    public XMLToQuery(LuceneIndex index) {
        this.index = index;
    }

    public Query parse(String field, Element root, Analyzer analyzer, Properties options) throws XPathException {
        Query query = null;
        String localName = root.getLocalName();
        if (null != localName) {
            switch (localName) {
                case "query": {
                    query = this.parseChildren(field, root, analyzer, options);
                    break;
                }
                case "term": {
                    query = this.termQuery(field, root, analyzer);
                    break;
                }
                case "wildcard": {
                    query = this.wildcardQuery(field, root, analyzer, options);
                    break;
                }
                case "prefix": {
                    query = this.prefixQuery(field, root, options);
                    break;
                }
                case "fuzzy": {
                    query = this.fuzzyQuery(field, root);
                    break;
                }
                case "bool": {
                    query = this.booleanQuery(field, root, analyzer, options);
                    break;
                }
                case "phrase": {
                    query = this.phraseQuery(field, root, analyzer);
                    break;
                }
                case "near": {
                    query = this.nearQuery(field, root, analyzer);
                    break;
                }
                case "first": {
                    query = this.getSpanFirst(field, root, analyzer);
                    break;
                }
                case "regex": {
                    query = this.regexQuery(field, root, options);
                    break;
                }
                default: {
                    throw new XPathException("Unknown element in lucene query expression: " + localName);
                }
            }
        }
        if (query != null) {
            this.setBoost(root, query);
        }
        return query;
    }

    private Query phraseQuery(String field, Element node, Analyzer analyzer) throws XPathException {
        NodeList termList = node.getElementsByTagName("term");
        if (termList.getLength() == 0) {
            PhraseQuery query = new PhraseQuery();
            String qstr = this.getText(node);
            try {
                TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(qstr));
                CharTermAttribute termAttr = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                stream.reset();
                while (stream.incrementToken()) {
                    query.add(new Term(field, termAttr.toString()));
                }
                stream.end();
                stream.close();
            }
            catch (IOException e) {
                throw new XPathException("Error while parsing phrase query: " + qstr);
            }
            int slop = this.getSlop(node);
            if (slop > -1) {
                query.setSlop(slop);
            }
            return query;
        }
        MultiPhraseQuery query = new MultiPhraseQuery();
        for (int i = 0; i < termList.getLength(); ++i) {
            Element elem = (Element)termList.item(i);
            String text = this.getText(elem);
            if (text.indexOf(63) > -1 || text.indexOf(42) > 0) {
                try {
                    Term[] expanded = this.expandTerms(field, text);
                    if (expanded.length <= 0) continue;
                    query.add(expanded);
                    continue;
                }
                catch (IOException e) {
                    throw new XPathException("IO error while expanding query terms: " + e.getMessage(), (Throwable)e);
                }
            }
            String termStr = this.getTerm(field, text, analyzer);
            if (termStr == null) continue;
            query.add(new Term(field, text));
        }
        int slop = this.getSlop(node);
        if (slop > -1) {
            query.setSlop(slop);
        }
        return query;
    }

    private SpanQuery nearQuery(String field, Element node, Analyzer analyzer) throws XPathException {
        int slop = this.getSlop(node);
        if (slop < 0) {
            slop = 0;
        }
        boolean inOrder = true;
        if (node.hasAttribute("ordered")) {
            inOrder = node.getAttribute("ordered").equals("yes");
        }
        if (!this.hasElementContent(node)) {
            String qstr = this.getText(node);
            ArrayList<SpanTermQuery> list = new ArrayList<SpanTermQuery>(8);
            try {
                TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(qstr));
                CharTermAttribute termAttr = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                stream.reset();
                while (stream.incrementToken()) {
                    list.add(new SpanTermQuery(new Term(field, termAttr.toString())));
                }
                stream.end();
                stream.close();
            }
            catch (IOException e) {
                throw new XPathException("Error while parsing phrase query: " + qstr);
            }
            return new SpanNearQuery((SpanQuery[])list.toArray(new SpanTermQuery[list.size()]), slop, inOrder);
        }
        SpanQuery[] children = this.parseSpanChildren(field, node, analyzer);
        return new SpanNearQuery(children, slop, inOrder);
    }

    private SpanQuery[] parseSpanChildren(String field, Element node, Analyzer analyzer) throws XPathException {
        ArrayList<SpanQuery> list = new ArrayList<SpanQuery>(8);
        block12: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String localName;
            if (child.getNodeType() != 1 || null == (localName = child.getLocalName())) continue;
            switch (localName) {
                case "term": {
                    this.getSpanTerm(list, field, (Element)child, analyzer);
                    continue block12;
                }
                case "near": {
                    list.add(this.nearQuery(field, (Element)child, analyzer));
                    continue block12;
                }
                case "first": {
                    list.add(this.getSpanFirst(field, (Element)child, analyzer));
                    continue block12;
                }
                case "regex": {
                    list.add(this.getSpanRegex(field, (Element)child, analyzer));
                    continue block12;
                }
                default: {
                    throw new XPathException("Unknown query element: " + child.getNodeName());
                }
            }
        }
        return list.toArray(new SpanQuery[list.size()]);
    }

    private void getSpanTerm(List<SpanQuery> list, String field, Element node, Analyzer analyzer) throws XPathException {
        String termStr = this.getTerm(field, this.getText(node), analyzer);
        if (termStr != null) {
            list.add((SpanQuery)new SpanTermQuery(new Term(field, termStr)));
        }
    }

    private SpanQuery getSpanRegex(String field, Element node, Analyzer analyzer) {
        String regex = this.getText(node);
        return new SpanMultiTermQueryWrapper((MultiTermQuery)new RegexpQuery(new Term(field, regex)));
    }

    private SpanQuery getSpanFirst(String field, Element node, Analyzer analyzer) throws XPathException {
        int slop = this.getSlop(node);
        if (slop < 0) {
            slop = 0;
        }
        boolean inOrder = true;
        if (node.hasAttribute("ordered")) {
            inOrder = node.getAttribute("ordered").equals("yes");
        }
        SpanNearQuery query = null;
        if (this.hasElementContent(node)) {
            SpanQuery[] children = this.parseSpanChildren(field, node, analyzer);
            query = new SpanNearQuery(children, slop, inOrder);
        } else {
            String termStr = this.getTerm(field, this.getText(node), analyzer);
            if (termStr != null) {
                query = new SpanTermQuery(new Term(field, termStr));
            }
        }
        int end = 0;
        if (node.hasAttribute("end")) {
            try {
                end = Integer.parseInt(node.getAttribute("end"));
            }
            catch (NumberFormatException e) {
                throw new XPathException("Attribute 'end' to query element 'first' should be a valid integer. Got: " + node.getAttribute("end"));
            }
        }
        return query != null ? new SpanFirstQuery((SpanQuery)query, end) : null;
    }

    private int getSlop(Element node) throws XPathException {
        String slop = node.getAttribute("slop");
        if (slop != null && slop.length() > 0) {
            try {
                return Integer.parseInt(slop);
            }
            catch (NumberFormatException e) {
                throw new XPathException("Query parameter 'slop' should be an integer value. Got: " + slop);
            }
        }
        return -1;
    }

    private Term[] expandTerms(String field, String queryStr) throws XPathException, IOException {
        return (Term[])this.index.withReader(reader -> {
            Automaton automaton = WildcardQuery.toAutomaton((Term)new Term(field, queryStr));
            CompiledAutomaton compiled = new CompiledAutomaton(automaton);
            ArrayList<Term> termList = new ArrayList<Term>(8);
            for (AtomicReaderContext atomic : reader.leaves()) {
                Terms terms = atomic.reader().terms(field);
                if (terms == null) continue;
                TermsEnum termsEnum = compiled.getTermsEnum(terms);
                BytesRef data = termsEnum.next();
                while (data != null) {
                    String term = data.utf8ToString();
                    termList.add(new Term(field, term));
                    data = termsEnum.next();
                }
            }
            Term[] matchingTerms = new Term[termList.size()];
            return termList.toArray(matchingTerms);
        });
    }

    private Query termQuery(String field, Element node, Analyzer analyzer) throws XPathException {
        String termStr = this.getTerm(field, this.getText(node), analyzer);
        return termStr == null ? null : new TermQuery(new Term(field, termStr));
    }

    private String getTerm(String field, String text, Analyzer analyzer) throws XPathException {
        String term = null;
        try {
            TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(text));
            CharTermAttribute termAttr = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            if (stream.incrementToken()) {
                term = termAttr.toString();
            }
            stream.end();
            stream.close();
            return term;
        }
        catch (IOException e) {
            throw new XPathException("Lucene index error while creating query: " + e.getMessage(), (Throwable)e);
        }
    }

    private Query wildcardQuery(String field, Element node, Analyzer analyzer, Properties options) throws XPathException {
        WildcardQuery query = new WildcardQuery(new Term(field, this.getText(node)));
        this.setRewriteMethod((MultiTermQuery)query, node, options);
        return query;
    }

    private Query prefixQuery(String field, Element node, Properties options) {
        PrefixQuery query = new PrefixQuery(new Term(field, this.getText(node)));
        this.setRewriteMethod((MultiTermQuery)query, node, options);
        return query;
    }

    private Query fuzzyQuery(String field, Element node) throws XPathException {
        int maxEdits = 2;
        String attr = node.getAttribute("max-edits");
        if (attr != null && attr.length() > 0) {
            try {
                maxEdits = Integer.parseInt(attr);
                if (maxEdits < 0 || maxEdits > 2) {
                    throw new XPathException("Query parameter max-edits must by <= 2");
                }
            }
            catch (NumberFormatException e) {
                throw new XPathException("Query parameter 'max-edits' should be an integer value. Got: " + attr);
            }
        }
        return new FuzzyQuery(new Term(field, this.getText(node)), maxEdits);
    }

    private Query regexQuery(String field, Element node, Properties options) {
        RegexpQuery query = new RegexpQuery(new Term(field, this.getText(node)));
        this.setRewriteMethod((MultiTermQuery)query, node, options);
        return query;
    }

    private Query booleanQuery(String field, Element node, Analyzer analyzer, Properties options) throws XPathException {
        BooleanQuery query = new BooleanQuery();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element elem;
            Query childQuery;
            if (child.getNodeType() != 1 || (childQuery = this.parse(field, elem = (Element)child, analyzer, options)) == null) continue;
            BooleanClause.Occur occur = this.getOccur(elem);
            query.add(childQuery, occur);
        }
        return query;
    }

    private void setRewriteMethod(MultiTermQuery query, Element node, Properties options) {
        String option = node.getAttribute("filter-rewrite");
        if (option == null) {
            option = "yes";
        }
        if (options != null) {
            option = options.getProperty("filter-rewrite", "yes");
        }
        if (option.equalsIgnoreCase("yes")) {
            query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
        } else {
            query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        }
    }

    private BooleanClause.Occur getOccur(Element elem) {
        BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
        String occurOpt = elem.getAttribute("occur");
        if (occurOpt != null) {
            switch (occurOpt) {
                case "must": {
                    occur = BooleanClause.Occur.MUST;
                    break;
                }
                case "not": {
                    occur = BooleanClause.Occur.MUST_NOT;
                    break;
                }
                case "should": {
                    occur = BooleanClause.Occur.SHOULD;
                }
            }
        }
        return occur;
    }

    private Query parseChildren(String field, Element root, Analyzer analyzer, Properties options) throws XPathException {
        Query query = null;
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Query childQuery = this.parse(field, (Element)child, analyzer, options);
            if (query != null) {
                if (query instanceof BooleanQuery) {
                    ((BooleanQuery)query).add(childQuery, BooleanClause.Occur.SHOULD);
                    continue;
                }
                BooleanQuery boolQuery = new BooleanQuery();
                boolQuery.add(query, BooleanClause.Occur.SHOULD);
                boolQuery.add(childQuery, BooleanClause.Occur.SHOULD);
                query = boolQuery;
                continue;
            }
            query = childQuery;
        }
        return query;
    }

    private void setBoost(Element node, Query query) throws XPathException {
        String boost = node.getAttribute("boost");
        if (boost != null && boost.length() > 0) {
            try {
                query.setBoost(Float.parseFloat(boost));
            }
            catch (NumberFormatException e) {
                throw new XPathException("Bad value for boost in query parameter. Got: " + boost);
            }
        }
    }

    private String getText(Element root) {
        StringBuilder buf = new StringBuilder();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            buf.append(child.getNodeValue());
        }
        return buf.toString();
    }

    private boolean hasElementContent(Element root) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }
}

