/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.lucene.analyzers;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.Version;
import org.exist.indexing.lucene.LuceneIndex;

public class NoDiacriticsStandardAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    private final boolean replaceInvalidAcronym;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public NoDiacriticsStandardAnalyzer(CharArraySet stopWords) {
        super(stopWords);
        this.replaceInvalidAcronym = true;
    }

    @Deprecated
    public NoDiacriticsStandardAnalyzer(Version matchVersion, CharArraySet stopWords) {
        super(matchVersion, stopWords);
        this.replaceInvalidAcronym = matchVersion.onOrAfter(LuceneIndex.LUCENE_VERSION_IN_USE);
    }

    protected NoDiacriticsStandardAnalyzer() {
        this((CharArraySet)null);
    }

    @Deprecated
    public NoDiacriticsStandardAnalyzer(Version matchVersion) {
        this(matchVersion, STOP_WORDS_SET);
    }

    public NoDiacriticsStandardAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((Reader)stopwords, (Version)matchVersion));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer src = new StandardTokenizer(this.getVersion(), reader);
        src.setMaxTokenLength(this.maxTokenLength);
        StandardFilter tok = new StandardFilter(this.getVersion(), (TokenStream)src);
        tok = new ICUFoldingFilter((TokenStream)tok);
        tok = new LowerCaseFilter(this.getVersion(), (TokenStream)tok);
        tok = new StopFilter(this.getVersion(), (TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }
}

