/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import java.io.IOException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.lucene.LuceneModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class GetField
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-field", "http://exist-db.org/xquery/lucene", "ft"), "Retrieve the stored content of a field.", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 7, "URI paths of documents or collections in database. Collection URIs should end on a '/'."), new FunctionParameterSequenceType("field", 22, 2, "query string")}, (SequenceType)new FunctionReturnSequenceType(22, 7, "All documents that are match by the query"))};

    public GetField(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        XmldbURI uri = XmldbURI.createInternal((String)args[0].getStringValue());
        String field = args[1].getStringValue();
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(uri, Lock.LockMode.READ_LOCK);
            if (doc == null) {
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
            String content = index.getFieldContent(doc.getDocId(), field);
            Sequence sequence = content == null ? Sequence.EMPTY_SEQUENCE : new StringValue(content);
            return sequence;
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, LuceneModule.EXXQDYFT0001, "Permission denied to read document " + args[0].getStringValue());
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, LuceneModule.EXXQDYFT0002, "IO error while reading document " + args[0].getStringValue());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }
}

