/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import java.io.IOException;
import java.net.URISyntaxException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.lucene.LuceneModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class InspectIndex
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("has-index", "http://exist-db.org/xquery/lucene", "ft"), "Check if the given document has a lucene index defined on it. This method will return true for both, indexes created via collection.xconf or manual index fields added to the document with ft:index.", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 2, "Full path to the resource to check")}, (SequenceType)new FunctionReturnSequenceType(23, 7, ""))};

    public InspectIndex(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String path = args[0].itemAt(0).getStringValue();
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor((String)path), Lock.LockMode.READ_LOCK);
            if (doc == null) {
                throw new XPathException((Expression)this, "Document " + path + " does not exist.");
            }
            LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
            BooleanValue booleanValue = new BooleanValue(index.hasIndex(doc.getDocId()));
            return booleanValue;
        }
        catch (PermissionDeniedException e) {
            throw new XPathException((Expression)this, LuceneModule.EXXQDYFT0001, e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new XPathException((Expression)this, LuceneModule.EXXQDYFT0003, e.getMessage());
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, LuceneModule.EXXQDYFT0002, e.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }
}

