/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryparser.classic.ParseException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.stax.ExtendedXMLStreamReader;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;

public class Query
extends Function
implements Optimizable {
    protected static final Logger logger = LogManager.getLogger(Query.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("query", "http://exist-db.org/xquery/lucene", "ft"), "Queries a node set using a Lucene full text index; a lucene index must already be defined on the nodes, because if no index is available on a node, nothing will be found. Indexes on descendant nodes are not used. The context of the Lucene query is determined by the given input node set. The query is specified either as a query string based on Lucene's default query syntax or as an XML fragment. See http://exist-db.org/lucene.html#N1029E for complete documentation.", new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 7, "The node set to search using a Lucene full text index which is defined on those nodes"), new FunctionParameterSequenceType("query", 11, 2, "The query to search for, provided either as a string or text in Lucene's default query syntax or as an XML fragment to bypass Lucene's default query parser")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set matching the query. match highlighting information will be available for all returned nodes. Lucene's match score can be retrieved via the ft:score function.")), new FunctionSignature(new QName("query", "http://exist-db.org/xquery/lucene", "ft"), "Queries a node set using a Lucene full text index; a lucene index must already be defined on the nodes, because if no index is available on a node, nothing will be found. Indexes on descendant nodes are not used. The context of the Lucene query is determined by the given input node set. The query is specified either as a query string based on Lucene's default query syntax or as an XML fragment. See http://exist-db.org/lucene.html#N1029E for complete documentation.", new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 7, "The node set to search using a Lucene full text index which is defined on those nodes"), new FunctionParameterSequenceType("query", 11, 2, "The query to search for, provided either as a string or text in Lucene's default query syntax or as an XML fragment to bypass Lucene's default query parser"), new FunctionParameterSequenceType("options", -1, 3, "An XML fragment containing options to be passed to Lucene's query parser. The following options are supported (a description can be found in the docs):\n<options>\n   <default-operator>and|or</default-operator>\n   <phrase-slop>number</phrase-slop>\n   <leading-wildcard>yes|no</leading-wildcard>\n   <filter-rewrite>yes|no</filter-rewrite>\n</options>")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set matching the query. match highlighting information will be available for all returned nodes. Lucene's match score can be retrieved via the ft:score function."))};
    private LocationStep contextStep = null;
    protected QName contextQName = null;
    protected int axis = -1;
    private NodeSet preselectResult = null;
    protected boolean optimizeSelf = false;
    protected boolean optimizeChild = false;

    public Query(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setArguments(List<Expression> arguments) throws XPathException {
        this.steps.clear();
        Expression path = arguments.get(0);
        this.steps.add(path);
        Expression arg = arguments.get(1).simplify();
        arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", (Object)"2", (Object)this.mySignature));
        this.add(arg);
        if (arguments.size() == 3) {
            arg = arguments.get(2).simplify();
            arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", (Object)"2", (Object)this.mySignature));
            arg = new DynamicTypeCheck(this.context, 1, arg);
            this.steps.add(arg);
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(new AnalyzeContextInfo(contextInfo));
        List steps = BasicExpressionVisitor.findLocationSteps((Expression)this.getArgument(0));
        if (!steps.isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (firstStep != null && steps.size() == 1 && firstStep.getAxis() == 12) {
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep) {
                    LocationStep outerStep = (LocationStep)outerExpr;
                    NodeTest test = outerStep.getTest();
                    byte contextQNameType = outerStep.getAxis() == 6 || outerStep.getAxis() == 13 ? (byte)1 : 0;
                    this.contextQName = test.getName() == null ? new QName(null, null, contextQNameType) : new QName(test.getName(), contextQNameType);
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else if (lastStep != null && firstStep != null) {
                NodeTest test = lastStep.getTest();
                this.contextQName = test.getName() == null ? new QName(null, null, null) : (test.isWildcardTest() ? test.getName() : (lastStep.getAxis() == 6 || lastStep.getAxis() == 13 ? new QName(test.getName(), 1) : new QName(test.getName())));
                this.axis = firstStep.getAxis();
                this.optimizeChild = steps.size() == 1 && (this.axis == 5 || this.axis == 6);
                this.contextStep = lastStep;
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        return this.contextQName != null;
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public boolean optimizeOnChild() {
        return this.optimizeChild;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            return NodeSet.EMPTY_SET;
        }
        long start = System.currentTimeMillis();
        this.preselectResult = null;
        LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
        DocumentSet docs = contextSequence.getDocumentSet();
        Item key = this.getKey(contextSequence, null);
        ArrayList<QName> qnames = new ArrayList<QName>(1);
        qnames.add(this.contextQName);
        Properties options = this.parseOptions(contextSequence, null);
        try {
            this.preselectResult = Type.subTypeOf((int)key.getType(), (int)1) ? index.query(this.context, this.getExpressionId(), docs, useContext ? contextSequence.toNodeSet() : null, qnames, (Element)((NodeValue)key).getNode(), 1, options) : index.query(this.context, this.getExpressionId(), docs, useContext ? contextSequence.toNodeSet() : null, qnames, key.getStringValue(), 1, options);
        }
        catch (IOException | ParseException e) {
            throw new XPathException((Expression)this, "Error while querying full text index: " + e.getMessage(), e);
        }
        LOG.trace("Lucene query took " + (System.currentTimeMillis() - start));
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "lucene", (Expression)this, 2, System.currentTimeMillis() - start);
        }
        return this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.preselectResult == null) {
            long start = System.currentTimeMillis();
            Sequence input = this.getArgument(0).eval(contextSequence);
            if (!(input instanceof VirtualNodeSet) && input.isEmpty()) {
                result = NodeSet.EMPTY_SET;
            } else {
                NodeSet inNodes = input.toNodeSet();
                DocumentSet docs = inNodes.getDocumentSet();
                LuceneIndexWorker index = (LuceneIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(LuceneIndex.ID);
                Item key = this.getKey(contextSequence, contextItem);
                ArrayList<QName> qnames = null;
                if (this.contextQName != null) {
                    qnames = new ArrayList<QName>(1);
                    qnames.add(this.contextQName);
                }
                Properties options = this.parseOptions(contextSequence, contextItem);
                try {
                    result = Type.subTypeOf((int)key.getType(), (int)1) ? index.query(this.context, this.getExpressionId(), docs, inNodes, qnames, (Element)((NodeValue)key).getNode(), 0, options) : index.query(this.context, this.getExpressionId(), docs, inNodes, qnames, key.getStringValue(), 0, options);
                }
                catch (IOException | ParseException e) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
            }
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceIndexUsage(this.context, "lucene", (Expression)this, 1, System.currentTimeMillis() - start);
            }
        } else {
            this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
            result = this.getArgument(0).eval(contextSequence).toNodeSet();
        }
        return result;
    }

    protected Item getKey(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence keySeq = this.getArgument(1).eval(contextSequence, contextItem);
        Item key = keySeq.itemAt(0);
        if (!Type.subTypeOf((int)key.getType(), (int)22) && !Type.subTypeOf((int)key.getType(), (int)-1)) {
            throw new XPathException((Expression)this, "Second argument to ft:query should either be a query string or an XML element describing the query. Found: " + Type.getTypeName((int)key.getType()));
        }
        return key;
    }

    public int getDependencies() {
        Expression stringArg = this.getArgument(0);
        if (Type.subTypeOf((int)stringArg.returnsType(), (int)-1) && !Dependency.dependsOn((Expression)stringArg, (int)2)) {
            return 1;
        }
        return 3;
    }

    public int returnsType() {
        return -1;
    }

    protected Properties parseOptions(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.getArgumentCount() < 3) {
            return null;
        }
        Properties options = new Properties();
        Sequence optSeq = this.getArgument(2).eval(contextSequence, contextItem);
        NodeValue optRoot = (NodeValue)optSeq.itemAt(0);
        try {
            ExtendedXMLStreamReader reader = this.context.getXMLStreamReader(optRoot);
            reader.next();
            reader.next();
            while (reader.hasNext()) {
                int status = reader.next();
                if (status != 1) continue;
                options.put(reader.getLocalName(), reader.getElementText());
            }
            return options;
        }
        catch (IOException | XMLStreamException e) {
            throw new XPathException((Expression)this, "Error while parsing options to ft:query: " + e.getMessage(), (Throwable)e);
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.preselectResult = null;
        }
    }
}

